Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/padEnd', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import createPadding from './_createPadding.js';
  import stringSize from './_stringSize.js';
  import toInteger from './toInteger.js';
  import toString from './toString.js';

  /**
   * Pads `string` on the right side if it's shorter than `length`. Padding
   * characters are truncated if they exceed `length`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to pad.
   * @param {number} [length=0] The padding length.
   * @param {string} [chars=' '] The string used as padding.
   * @returns {string} Returns the padded string.
   * @example
   *
   * _.padEnd('abc', 6);
   * // => 'abc   '
   *
   * _.padEnd('abc', 6, '_-');
   * // => 'abc_-_'
   *
   * _.padEnd('abc', 3);
   * // => 'abc'
   */
  function padEnd(string, length, chars) {
    string = toString(string);
    length = toInteger(length);

    var strLength = length ? stringSize(string) : 0;
    return length && strLength < length ? string + createPadding(length - strLength, chars) : string;
  }

  export default padEnd;
});
//# sourceMappingURL=padEnd.js.map