Liferay.Loader.define("frontend-js-tabs-support-web@1.0.8/TabsProvider", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var CssClass = {
    ACTIVE: 'active',
    SHOW: 'show'
  };
  var Selector = {
    TRIGGER: '[data-toggle="liferay-tab"]'
  };

  var TabsProvider = /*#__PURE__*/function () {
    function TabsProvider() {
      var _this = this;

      _classCallCheck(this, TabsProvider);

      _defineProperty(this, "EVENT_HIDDEN", 'liferay.tabs.hidden');

      _defineProperty(this, "EVENT_HIDE", 'liferay.tabs.hide');

      _defineProperty(this, "EVENT_SHOW", 'liferay.tabs.show');

      _defineProperty(this, "EVENT_SHOWN", 'liferay.tabs.shown');

      _defineProperty(this, "hide", function (_ref) {
        var panel = _ref.panel,
            trigger = _ref.trigger;

        if (panel && !trigger) {
          trigger = _this._getTrigger(panel);
        }

        if (!panel) {
          panel = _this._getPanel(trigger);
        }

        if (_this._transitioning || !panel.classList.contains(CssClass.SHOW)) {
          return;
        }

        Liferay.fire(_this.EVENT_HIDE, {
          panel: panel,
          trigger: trigger
        });
        trigger.classList.remove(CssClass.ACTIVE);
        trigger.setAttribute('aria-selected', false);
        panel.classList.remove(CssClass.SHOW);
        _this._transitioning = true;

        _metalDom["default"].once(panel, _this._transitionEndEvent, function () {
          panel.classList.remove(CssClass.ACTIVE);
          _this._transitioning = false;
          Liferay.fire(_this.EVENT_HIDDEN, {
            panel: panel,
            trigger: trigger
          });
        });
      });

      _defineProperty(this, "show", function (_ref2) {
        var panel = _ref2.panel,
            trigger = _ref2.trigger;

        if (panel && !trigger) {
          trigger = _this._getTrigger(panel);
        }

        if (!panel) {
          panel = _this._getPanel(trigger);
        }

        if (_this._transitioning || panel.classList.contains(CssClass.SHOW)) {
          return;
        }

        var panels = Array.from(panel.parentElement.children);
        var activePanels = panels.filter(function (item) {
          return item.classList.contains(CssClass.SHOW);
        });

        if (activePanels.length) {
          var activePanel = activePanels[0];
          Liferay.on(_this.EVENT_HIDDEN, function (event) {
            if (event.panel === activePanel) {
              _this.show({
                panel: panel,
                trigger: trigger
              });
            }
          });

          _this.hide({
            panel: activePanel
          });
        } else {
          Liferay.fire(_this.EVENT_SHOW, {
            panel: panel,
            trigger: trigger
          });
          trigger.classList.add(CssClass.ACTIVE);
          trigger.setAttribute('aria-selected', true);
          panel.classList.add(CssClass.ACTIVE);
          panel.classList.add(CssClass.SHOW);
          Liferay.fire(_this.EVENT_SHOWN, {
            panel: panel,
            trigger: trigger
          });
        }
      });

      _defineProperty(this, "_onTriggerClick", function (event) {
        var trigger = event.delegateTarget;

        if (trigger.tagName === 'A') {
          event.preventDefault();
        }

        var panel = _this._getPanel(trigger);

        if (panel && !panel.classList.contains(CssClass.SHOW)) {
          _this.show({
            panel: panel,
            trigger: trigger
          });
        }
      });

      if (Liferay.TabsProvider) {
        return Liferay.TabsProvider;
      }

      this._setTransitionEndEvent();

      _metalDom["default"].delegate(document.body, 'click', Selector.TRIGGER, this._onTriggerClick);

      Liferay.TabsProvider = this;
    }

    _createClass(TabsProvider, [{
      key: "_getPanel",
      value: function _getPanel(trigger) {
        return document.querySelector(trigger.getAttribute('href'));
      }
    }, {
      key: "_getTrigger",
      value: function _getTrigger(panel) {
        return document.querySelector("[href=\"#".concat(panel.getAttribute('id'), "\"]"));
      }
    }, {
      key: "_setTransitionEndEvent",
      value: function _setTransitionEndEvent() {
        var sampleElement = document.body;
        var transitionEndEvents = {
          MozTransition: 'transitionend',
          OTransition: 'oTransitionEnd otransitionend',
          WebkitTransition: 'webkitTransitionEnd',
          transition: 'transitionend'
        };
        var eventName = false;
        Object.keys(transitionEndEvents).some(function (name) {
          if (sampleElement.style[name] !== undefined) {
            eventName = transitionEndEvents[name];
            return true;
          }
        });
        this._transitionEndEvent = eventName;
      }
    }]);

    return TabsProvider;
  }();

  var _default = TabsProvider;
  exports["default"] = _default;
  //# sourceMappingURL=TabsProvider.js.map
});
//# sourceMappingURL=TabsProvider.js.map