// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)
'use strict';

Liferay.Loader.define('frontend-js-spa-web$core-js@2.5.7/modules/_array-copy-within', ['module', 'exports', 'require', './_to-object', './_to-absolute-index', './_to-length'], function (module, exports, require) {
  var define = undefined;
  var toObject = require('./_to-object');
  var toAbsoluteIndex = require('./_to-absolute-index');
  var toLength = require('./_to-length');

  module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
    var O = toObject(this);
    var len = toLength(O.length);
    var to = toAbsoluteIndex(target, len);
    var from = toAbsoluteIndex(start, len);
    var end = arguments.length > 2 ? arguments[2] : undefined;
    var count = Math.min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
    var inc = 1;
    if (from < to && to < from + count) {
      inc = -1;
      from += count - 1;
      to += count - 1;
    }
    while (count-- > 0) {
      if (from in O) O[to] = O[from];else delete O[to];
      to += inc;
      from += inc;
    }return O;
  };
});
//# sourceMappingURL=_array-copy-within.js.map