"use strict";

Liferay.Loader.define("frontend-js-react-web$react-dnd@11.1.1/dist/cjs/hooks/useDragLayer", ['module', 'exports', 'require', 'frontend-js-react-web$react', './useDragDropManager', './internal/useCollector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDragLayer = useDragLayer;

    var _react = require("frontend-js-react-web$react");

    var _useDragDropManager = require("./useDragDropManager");

    var _useCollector3 = require("./internal/useCollector");

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _unsupportedIterableToArray(o, minLen) {
      if (!o) return;if (typeof o === "string") return _arrayLikeToArray(o, minLen);var n = Object.prototype.toString.call(o).slice(8, -1);if (n === "Object" && o.constructor) n = o.constructor.name;if (n === "Map" || n === "Set") return Array.from(o);if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
    }

    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length) len = arr.length;for (var i = 0, arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }

    function _iterableToArrayLimit(arr, i) {
      if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * useDragLayer Hook
     * @param collector The property collector
     */
    function useDragLayer(collect) {
      var dragDropManager = (0, _useDragDropManager.useDragDropManager)();
      var monitor = dragDropManager.getMonitor();

      var _useCollector = (0, _useCollector3.useCollector)(monitor, collect),
          _useCollector2 = _slicedToArray(_useCollector, 2),
          collected = _useCollector2[0],
          updateCollected = _useCollector2[1];

      (0, _react.useEffect)(function () {
        return monitor.subscribeToOffsetChange(updateCollected);
      });
      (0, _react.useEffect)(function () {
        return monitor.subscribeToStateChange(updateCollected);
      });
      return collected;
    }
  }
});
//# sourceMappingURL=useDragLayer.js.map