"use strict";

Liferay.Loader.define("frontend-js-react-web$react-dnd@11.1.1/dist/cjs/common/TargetConnector", ['module', 'exports', 'require', '@frontend-js-react-web$react-dnd/shallowequal', './wrapConnectorHooks', '../utils/isRef'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.TargetConnector = void 0;

    var _shallowequal = require("@frontend-js-react-web$react-dnd/shallowequal");

    var _wrapConnectorHooks = require("./wrapConnectorHooks");

    var _isRef = require("../utils/isRef");

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    var TargetConnector = /*#__PURE__*/function () {
      function TargetConnector(backend) {
        var _this = this;

        _classCallCheck(this, TargetConnector);

        this.hooks = (0, _wrapConnectorHooks.wrapConnectorHooks)({
          dropTarget: function dropTarget(node, options) {
            _this.clearDropTarget();

            _this.dropTargetOptions = options;

            if ((0, _isRef.isRef)(node)) {
              _this.dropTargetRef = node;
            } else {
              _this.dropTargetNode = node;
            }

            _this.reconnect();
          }
        });
        this.handlerId = null; // The drop target may either be attached via ref or connect function

        this.dropTargetRef = null;
        this.dropTargetOptionsInternal = null;
        this.lastConnectedHandlerId = null;
        this.lastConnectedDropTarget = null;
        this.lastConnectedDropTargetOptions = null;
        this.backend = backend;
      }

      _createClass(TargetConnector, [{
        key: "reconnect",
        value: function reconnect() {
          // if nothing has changed then don't resubscribe
          var didChange = this.didHandlerIdChange() || this.didDropTargetChange() || this.didOptionsChange();

          if (didChange) {
            this.disconnectDropTarget();
          }

          var dropTarget = this.dropTarget;

          if (!this.handlerId) {
            return;
          }

          if (!dropTarget) {
            this.lastConnectedDropTarget = dropTarget;
            return;
          }

          if (didChange) {
            this.lastConnectedHandlerId = this.handlerId;
            this.lastConnectedDropTarget = dropTarget;
            this.lastConnectedDropTargetOptions = this.dropTargetOptions;
            this.unsubscribeDropTarget = this.backend.connectDropTarget(this.handlerId, dropTarget, this.dropTargetOptions);
          }
        }
      }, {
        key: "receiveHandlerId",
        value: function receiveHandlerId(newHandlerId) {
          if (newHandlerId === this.handlerId) {
            return;
          }

          this.handlerId = newHandlerId;
          this.reconnect();
        }
      }, {
        key: "didHandlerIdChange",
        value: function didHandlerIdChange() {
          return this.lastConnectedHandlerId !== this.handlerId;
        }
      }, {
        key: "didDropTargetChange",
        value: function didDropTargetChange() {
          return this.lastConnectedDropTarget !== this.dropTarget;
        }
      }, {
        key: "didOptionsChange",
        value: function didOptionsChange() {
          return !(0, _shallowequal.shallowEqual)(this.lastConnectedDropTargetOptions, this.dropTargetOptions);
        }
      }, {
        key: "disconnectDropTarget",
        value: function disconnectDropTarget() {
          if (this.unsubscribeDropTarget) {
            this.unsubscribeDropTarget();
            this.unsubscribeDropTarget = undefined;
          }
        }
      }, {
        key: "clearDropTarget",
        value: function clearDropTarget() {
          this.dropTargetRef = null;
          this.dropTargetNode = null;
        }
      }, {
        key: "connectTarget",
        get: function get() {
          return this.dropTarget;
        }
      }, {
        key: "dropTargetOptions",
        get: function get() {
          return this.dropTargetOptionsInternal;
        },
        set: function set(options) {
          this.dropTargetOptionsInternal = options;
        }
      }, {
        key: "dropTarget",
        get: function get() {
          return this.dropTargetNode || this.dropTargetRef && this.dropTargetRef.current;
        }
      }]);

      return TargetConnector;
    }();

    exports.TargetConnector = TargetConnector;
  }
});
//# sourceMappingURL=TargetConnector.js.map