Liferay.Loader.define('frontend-js-react-web$react-dnd-html5-backend@11.1.1/lib/EnterLeaveCounter', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { union, without } from './utils/js_utils';
        export class EnterLeaveCounter {
            constructor(isNodeInDocument) {
                this.entered = [];
                this.isNodeInDocument = isNodeInDocument;
            }
            enter(enteringNode) {
                const previousLength = this.entered.length;

                this.entered = union(this.entered.filter(node => this.isNodeInDocument(node) && (!node.contains || node.contains(enteringNode))), [enteringNode]);
                return previousLength === 0 && this.entered.length > 0;
            }
            leave(leavingNode) {
                const previousLength = this.entered.length;
                this.entered = without(this.entered.filter(this.isNodeInDocument), leavingNode);
                return previousLength > 0 && this.entered.length === 0;
            }
            reset() {
                this.entered = [];
            }
        }
    }
});
//# sourceMappingURL=EnterLeaveCounter.js.map