Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/nthArg', ['module', 'exports', 'require', './_baseNth', './_baseRest', './toInteger'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseNth = require('./_baseNth'),
        baseRest = require('./_baseRest'),
        toInteger = require('./toInteger');

    /**
     * Creates a function that gets the argument at index `n`. If `n` is negative,
     * the nth argument from the end is returned.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {number} [n=0] The index of the argument to return.
     * @returns {Function} Returns the new pass-thru function.
     * @example
     *
     * var func = _.nthArg(1);
     * func('a', 'b', 'c', 'd');
     * // => 'b'
     *
     * var func = _.nthArg(-2);
     * func('a', 'b', 'c', 'd');
     * // => 'c'
     */
    function nthArg(n) {
      n = toInteger(n);
      return baseRest(function (args) {
        return baseNth(args, n);
      });
    }

    module.exports = nthArg;
  }
});
//# sourceMappingURL=nthArg.js.map