Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/maxBy', ['module', 'exports', 'require', './_baseExtremum', './_baseGt', './_baseIteratee'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseExtremum = require('./_baseExtremum'),
            baseGt = require('./_baseGt'),
            baseIteratee = require('./_baseIteratee');

        /**
         * This method is like `_.max` except that it accepts `iteratee` which is
         * invoked for each element in `array` to generate the criterion by which
         * the value is ranked. The iteratee is invoked with one argument: (value).
         *
         * @static
         * @memberOf _
         * @since 4.0.0
         * @category Math
         * @param {Array} array The array to iterate over.
         * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
         * @returns {*} Returns the maximum value.
         * @example
         *
         * var objects = [{ 'n': 1 }, { 'n': 2 }];
         *
         * _.maxBy(objects, function(o) { return o.n; });
         * // => { 'n': 2 }
         *
         * // The `_.property` iteratee shorthand.
         * _.maxBy(objects, 'n');
         * // => { 'n': 2 }
         */
        function maxBy(array, iteratee) {
            return array && array.length ? baseExtremum(array, baseIteratee(iteratee, 2), baseGt) : undefined;
        }

        module.exports = maxBy;
    }
});
//# sourceMappingURL=maxBy.js.map