Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/isString', ['module', 'exports', 'require', './_baseGetTag', './isArray', './isObjectLike'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseGetTag = require('./_baseGetTag'),
            isArray = require('./isArray'),
            isObjectLike = require('./isObjectLike');

        /** `Object#toString` result references. */
        var stringTag = '[object String]';

        /**
         * Checks if `value` is classified as a `String` primitive or object.
         *
         * @static
         * @since 0.1.0
         * @memberOf _
         * @category Lang
         * @param {*} value The value to check.
         * @returns {boolean} Returns `true` if `value` is a string, else `false`.
         * @example
         *
         * _.isString('abc');
         * // => true
         *
         * _.isString(1);
         * // => false
         */
        function isString(value) {
            return typeof value == 'string' || !isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag;
        }

        module.exports = isString;
    }
});
//# sourceMappingURL=isString.js.map