Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/bindAll', ['module', 'exports', 'require', './_arrayEach', './_baseAssignValue', './bind', './_flatRest', './_toKey'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var arrayEach = require('./_arrayEach'),
        baseAssignValue = require('./_baseAssignValue'),
        bind = require('./bind'),
        flatRest = require('./_flatRest'),
        toKey = require('./_toKey');

    /**
     * Binds methods of an object to the object itself, overwriting the existing
     * method.
     *
     * **Note:** This method doesn't set the "length" property of bound functions.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {Object} object The object to bind and assign the bound methods to.
     * @param {...(string|string[])} methodNames The object method names to bind.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var view = {
     *   'label': 'docs',
     *   'click': function() {
     *     console.log('clicked ' + this.label);
     *   }
     * };
     *
     * _.bindAll(view, ['click']);
     * jQuery(element).on('click', view.click);
     * // => Logs 'clicked docs' when clicked.
     */
    var bindAll = flatRest(function (object, methodNames) {
      arrayEach(methodNames, function (key) {
        key = toKey(key);
        baseAssignValue(object, key, bind(object[key], object));
      });
      return object;
    });

    module.exports = bindAll;
  }
});
//# sourceMappingURL=bindAll.js.map