Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_listCacheDelete', ['module', 'exports', 'require', './_assocIndexOf'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var assocIndexOf = require('./_assocIndexOf');

    /** Used for built-in method references. */
    var arrayProto = Array.prototype;

    /** Built-in value references. */
    var splice = arrayProto.splice;

    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function listCacheDelete(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      --this.size;
      return true;
    }

    module.exports = listCacheDelete;
  }
});
//# sourceMappingURL=_listCacheDelete.js.map