Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_createRelationalOperation', ['module', 'exports', 'require', './toNumber'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var toNumber = require('./toNumber');

    /**
     * Creates a function that performs a relational operation on two values.
     *
     * @private
     * @param {Function} operator The function to perform the operation.
     * @returns {Function} Returns the new relational operation function.
     */
    function createRelationalOperation(operator) {
      return function (value, other) {
        if (!(typeof value == 'string' && typeof other == 'string')) {
          value = toNumber(value);
          other = toNumber(other);
        }
        return operator(value, other);
      };
    }

    module.exports = createRelationalOperation;
  }
});
//# sourceMappingURL=_createRelationalOperation.js.map