Liferay.Loader.define("frontend-js-react-web@4.0.16/js/hooks/useIsMounted.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = useIsMounted;

    var _react = require("frontend-js-react-web$react");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Hook for determining whether a component is still mounted.
     *
     * Use this to guard side-effects of asynchronous operations (fetches,
     * promises) that may complete after a component has been unmounted.
     *
     * Example:
     *
     *      const isMounted = useIsMounted();
     *      const [value, setHidden] = useHidden(true);
     *
     *      setTimeout(() => {
     *          if (isMounted()) {
     *              setHidden(true);
     *          }
     *      }, 1000);
     *
     */
    function useIsMounted() {
      var mountedRef = (0, _react.useRef)(false);
      var isMounted = (0, _react.useCallback)(function () {
        return mountedRef.current;
      }, []);
      (0, _react.useLayoutEffect)(function () {
        mountedRef.current = true;
        return function () {
          mountedRef.current = false;
        };
      }, []);
      return isMounted;
    }
    //# sourceMappingURL=useIsMounted.es.js.map
  }
});
//# sourceMappingURL=useIsMounted.es.js.map