Liferay.Loader.define("frontend-js-react-web$react-dnd@11.1.1/dist/esm/decorators/disposables", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  import { isFunction, noop } from '../utils/js_utils';
  /**
   * Provides a set of static methods for creating Disposables.
   * @param {Function} action Action to run during the first call to dispose.
   * The action is guaranteed to be run at most once.
   */

  var Disposable =
  /** @class */
  function () {
    var Disposable = /*#__PURE__*/function () {
      function Disposable(action) {
        _classCallCheck(this, Disposable);

        this.isDisposed = false;
        this.action = isFunction(action) ? action : noop;
      }
      /**
       * Validates whether the given object is a disposable
       * @param {Object} Object to test whether it has a dispose method
       * @returns {Boolean} true if a disposable object, else false.
       */

      _createClass(Disposable, [{
        key: "dispose",

        /** Performs the task of cleaning up resources. */
        value: function dispose() {
          if (!this.isDisposed) {
            this.action();
            this.isDisposed = true;
          }
        }
      }], [{
        key: "isDisposable",
        value: function isDisposable(d) {
          return Boolean(d && isFunction(d.dispose));
        }
      }, {
        key: "_fixup",
        value: function _fixup(result) {
          return Disposable.isDisposable(result) ? result : Disposable.empty;
        }
        /**
         * Creates a disposable object that invokes the specified action when disposed.
         * @param {Function} dispose Action to run during the first call to dispose.
         * The action is guaranteed to be run at most once.
         * @return {Disposable} The disposable object that runs the given action upon disposal.
         */

      }, {
        key: "create",
        value: function create(action) {
          return new Disposable(action);
        }
      }]);

      return Disposable;
    }();
    /**
     * Gets the disposable that does nothing when disposed.
     */

    Disposable.empty = {
      dispose: noop
    };
    return Disposable;
  }();

  export { Disposable };
  /**
   * Represents a group of disposable resources that are disposed together.
   * @constructor
   */

  export var CompositeDisposable = /*#__PURE__*/function () {
    function CompositeDisposable() {
      _classCallCheck(this, CompositeDisposable);

      this.isDisposed = false;

      for (var _len = arguments.length, disposables = new Array(_len), _key = 0; _key < _len; _key++) {
        disposables[_key] = arguments[_key];
      }

      this.disposables = disposables;
    }
    /**
     * Adds a disposable to the CompositeDisposable or disposes the disposable if the CompositeDisposable is disposed.
     * @param {Any} item Disposable to add.
     */

    _createClass(CompositeDisposable, [{
      key: "add",
      value: function add(item) {
        if (this.isDisposed) {
          item.dispose();
        } else {
          this.disposables.push(item);
        }
      }
      /**
       * Removes and disposes the first occurrence of a disposable from the CompositeDisposable.
       * @param {Any} item Disposable to remove.
       * @returns {Boolean} true if found; false otherwise.
       */

    }, {
      key: "remove",
      value: function remove(item) {
        var shouldDispose = false;

        if (!this.isDisposed) {
          var idx = this.disposables.indexOf(item);

          if (idx !== -1) {
            shouldDispose = true;
            this.disposables.splice(idx, 1);
            item.dispose();
          }
        }

        return shouldDispose;
      }
      /**
       *  Disposes all disposables in the group and removes them from the group but
       *  does not dispose the CompositeDisposable.
       */

    }, {
      key: "clear",
      value: function clear() {
        if (!this.isDisposed) {
          var len = this.disposables.length;
          var currentDisposables = new Array(len);

          for (var i = 0; i < len; i++) {
            currentDisposables[i] = this.disposables[i];
          }

          this.disposables = [];

          for (var _i = 0; _i < len; _i++) {
            currentDisposables[_i].dispose();
          }
        }
      }
      /**
       *  Disposes all disposables in the group and removes them from the group.
       */

    }, {
      key: "dispose",
      value: function dispose() {
        if (!this.isDisposed) {
          this.isDisposed = true;
          var len = this.disposables.length;
          var currentDisposables = new Array(len);

          for (var i = 0; i < len; i++) {
            currentDisposables[i] = this.disposables[i];
          }

          this.disposables = [];

          for (var _i2 = 0; _i2 < len; _i2++) {
            currentDisposables[_i2].dispose();
          }
        }
      }
    }]);

    return CompositeDisposable;
  }();
  /**
   * Represents a disposable resource whose underlying disposable resource can
   * be replaced by another disposable resource, causing automatic disposal of
   * the previous underlying disposable resource.
   */

  export var SerialDisposable = /*#__PURE__*/function () {
    function SerialDisposable() {
      _classCallCheck(this, SerialDisposable);

      this.isDisposed = false;
    }
    /**
     * Gets the underlying disposable.
     * @returns {Any} the underlying disposable.
     */

    _createClass(SerialDisposable, [{
      key: "getDisposable",
      value: function getDisposable() {
        return this.current;
      }
    }, {
      key: "setDisposable",
      value: function setDisposable(value) {
        var shouldDispose = this.isDisposed;

        if (!shouldDispose) {
          var old = this.current;
          this.current = value;

          if (old) {
            old.dispose();
          }
        }

        if (shouldDispose && value) {
          value.dispose();
        }
      }
      /** Performs the task of cleaning up resources. */

    }, {
      key: "dispose",
      value: function dispose() {
        if (!this.isDisposed) {
          this.isDisposed = true;
          var old = this.current;
          this.current = undefined;

          if (old) {
            old.dispose();
          }
        }
      }
    }]);

    return SerialDisposable;
  }();
});
//# sourceMappingURL=disposables.js.map