Liferay.Loader.define('frontend-js-react-web$react-dnd-html5-backend@11.1.1/lib/NativeDragSources/nativeTypesConfig', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    import * as NativeTypes from '../NativeTypes';
    import { getDataFromDataTransfer } from './getDataFromDataTransfer';
    export const nativeTypesConfig = {
        [NativeTypes.FILE]: {
            exposeProperties: {
                files: dataTransfer => Array.prototype.slice.call(dataTransfer.files),
                items: dataTransfer => dataTransfer.items
            },
            matchesTypes: ['Files']
        },
        [NativeTypes.URL]: {
            exposeProperties: {
                urls: (dataTransfer, matchesTypes) => getDataFromDataTransfer(dataTransfer, matchesTypes, '').split('\n')
            },
            matchesTypes: ['Url', 'text/uri-list']
        },
        [NativeTypes.TEXT]: {
            exposeProperties: {
                text: (dataTransfer, matchesTypes) => getDataFromDataTransfer(dataTransfer, matchesTypes, '')
            },
            matchesTypes: ['Text', 'text/plain']
        }
    };
});
//# sourceMappingURL=nativeTypesConfig.js.map