Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/toUpper', ['module', 'exports', 'require', './toString'], function (module, exports, require) {
  var define = undefined;
  var toString = require('./toString');

  /**
   * Converts `string`, as a whole, to upper case just like
   * [String#toUpperCase](https://mdn.io/toUpperCase).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the upper cased string.
   * @example
   *
   * _.toUpper('--foo-bar--');
   * // => '--FOO-BAR--'
   *
   * _.toUpper('fooBar');
   * // => 'FOOBAR'
   *
   * _.toUpper('__foo_bar__');
   * // => '__FOO_BAR__'
   */
  function toUpper(value) {
    return toString(value).toUpperCase();
  }

  module.exports = toUpper;
});
//# sourceMappingURL=toUpper.js.map