Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/toLower', ['module', 'exports', 'require', './toString'], function (module, exports, require) {
  var define = undefined;
  var toString = require('./toString');

  /**
   * Converts `string`, as a whole, to lower case just like
   * [String#toLowerCase](https://mdn.io/toLowerCase).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the lower cased string.
   * @example
   *
   * _.toLower('--Foo-Bar--');
   * // => '--foo-bar--'
   *
   * _.toLower('fooBar');
   * // => 'foobar'
   *
   * _.toLower('__FOO_BAR__');
   * // => '__foo_bar__'
   */
  function toLower(value) {
    return toString(value).toLowerCase();
  }

  module.exports = toLower;
});
//# sourceMappingURL=toLower.js.map