Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/toArray', ['module', 'exports', 'require', './_Symbol', './_copyArray', './_getTag', './isArrayLike', './isString', './_iteratorToArray', './_mapToArray', './_setToArray', './_stringToArray', './values'], function (module, exports, require) {
  var define = undefined;
  var Symbol = require('./_Symbol'),
      copyArray = require('./_copyArray'),
      getTag = require('./_getTag'),
      isArrayLike = require('./isArrayLike'),
      isString = require('./isString'),
      iteratorToArray = require('./_iteratorToArray'),
      mapToArray = require('./_mapToArray'),
      setToArray = require('./_setToArray'),
      stringToArray = require('./_stringToArray'),
      values = require('./values');

  /** `Object#toString` result references. */
  var mapTag = '[object Map]',
      setTag = '[object Set]';

  /** Built-in value references. */
  var symIterator = Symbol ? Symbol.iterator : undefined;

  /**
   * Converts `value` to an array.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Lang
   * @param {*} value The value to convert.
   * @returns {Array} Returns the converted array.
   * @example
   *
   * _.toArray({ 'a': 1, 'b': 2 });
   * // => [1, 2]
   *
   * _.toArray('abc');
   * // => ['a', 'b', 'c']
   *
   * _.toArray(1);
   * // => []
   *
   * _.toArray(null);
   * // => []
   */
  function toArray(value) {
    if (!value) {
      return [];
    }
    if (isArrayLike(value)) {
      return isString(value) ? stringToArray(value) : copyArray(value);
    }
    if (symIterator && value[symIterator]) {
      return iteratorToArray(value[symIterator]());
    }
    var tag = getTag(value),
        func = tag == mapTag ? mapToArray : tag == setTag ? setToArray : values;

    return func(value);
  }

  module.exports = toArray;
});
//# sourceMappingURL=toArray.js.map