Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/startsWith', ['module', 'exports', 'require', './_baseClamp', './_baseToString', './toInteger', './toString'], function (module, exports, require) {
  var define = undefined;
  var baseClamp = require('./_baseClamp'),
      baseToString = require('./_baseToString'),
      toInteger = require('./toInteger'),
      toString = require('./toString');

  /**
   * Checks if `string` starts with the given target string.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to inspect.
   * @param {string} [target] The string to search for.
   * @param {number} [position=0] The position to search from.
   * @returns {boolean} Returns `true` if `string` starts with `target`,
   *  else `false`.
   * @example
   *
   * _.startsWith('abc', 'a');
   * // => true
   *
   * _.startsWith('abc', 'b');
   * // => false
   *
   * _.startsWith('abc', 'b', 1);
   * // => true
   */
  function startsWith(string, target, position) {
    string = toString(string);
    position = position == null ? 0 : baseClamp(toInteger(position), 0, string.length);

    target = baseToString(target);
    return string.slice(position, position + target.length) == target;
  }

  module.exports = startsWith;
});
//# sourceMappingURL=startsWith.js.map