Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/repeat', ['module', 'exports', 'require', './_baseRepeat', './_isIterateeCall', './toInteger', './toString'], function (module, exports, require) {
  var define = undefined;
  var baseRepeat = require('./_baseRepeat'),
      isIterateeCall = require('./_isIterateeCall'),
      toInteger = require('./toInteger'),
      toString = require('./toString');

  /**
   * Repeats the given string `n` times.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to repeat.
   * @param {number} [n=1] The number of times to repeat the string.
   * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
   * @returns {string} Returns the repeated string.
   * @example
   *
   * _.repeat('*', 3);
   * // => '***'
   *
   * _.repeat('abc', 2);
   * // => 'abcabc'
   *
   * _.repeat('abc', 0);
   * // => ''
   */
  function repeat(string, n, guard) {
    if (guard ? isIterateeCall(string, n, guard) : n === undefined) {
      n = 1;
    } else {
      n = toInteger(n);
    }
    return baseRepeat(toString(string), n);
  }

  module.exports = repeat;
});
//# sourceMappingURL=repeat.js.map