Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/pullAt', ['module', 'exports', 'require', './_arrayMap', './_baseAt', './_basePullAt', './_compareAscending', './_flatRest', './_isIndex'], function (module, exports, require) {
    var define = undefined;
    var arrayMap = require('./_arrayMap'),
        baseAt = require('./_baseAt'),
        basePullAt = require('./_basePullAt'),
        compareAscending = require('./_compareAscending'),
        flatRest = require('./_flatRest'),
        isIndex = require('./_isIndex');

    /**
     * Removes elements from `array` corresponding to `indexes` and returns an
     * array of removed elements.
     *
     * **Note:** Unlike `_.at`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...(number|number[])} [indexes] The indexes of elements to remove.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = ['a', 'b', 'c', 'd'];
     * var pulled = _.pullAt(array, [1, 3]);
     *
     * console.log(array);
     * // => ['a', 'c']
     *
     * console.log(pulled);
     * // => ['b', 'd']
     */
    var pullAt = flatRest(function (array, indexes) {
        var length = array == null ? 0 : array.length,
            result = baseAt(array, indexes);

        basePullAt(array, arrayMap(indexes, function (index) {
            return isIndex(index, length) ? +index : index;
        }).sort(compareAscending));

        return result;
    });

    module.exports = pullAt;
});
//# sourceMappingURL=pullAt.js.map