Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/pullAll', ['module', 'exports', 'require', './_basePullAll'], function (module, exports, require) {
  var define = undefined;
  var basePullAll = require('./_basePullAll');

  /**
   * This method is like `_.pull` except that it accepts an array of values to remove.
   *
   * **Note:** Unlike `_.difference`, this method mutates `array`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {Array} array The array to modify.
   * @param {Array} values The values to remove.
   * @returns {Array} Returns `array`.
   * @example
   *
   * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
   *
   * _.pullAll(array, ['a', 'c']);
   * console.log(array);
   * // => ['b', 'b']
   */
  function pullAll(array, values) {
    return array && array.length && values && values.length ? basePullAll(array, values) : array;
  }

  module.exports = pullAll;
});
//# sourceMappingURL=pullAll.js.map