Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/padStart', ['module', 'exports', 'require', './_createPadding', './_stringSize', './toInteger', './toString'], function (module, exports, require) {
    var define = undefined;
    var createPadding = require('./_createPadding'),
        stringSize = require('./_stringSize'),
        toInteger = require('./toInteger'),
        toString = require('./toString');

    /**
     * Pads `string` on the left side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padStart('abc', 6);
     * // => '   abc'
     *
     * _.padStart('abc', 6, '_-');
     * // => '_-_abc'
     *
     * _.padStart('abc', 3);
     * // => 'abc'
     */
    function padStart(string, length, chars) {
        string = toString(string);
        length = toInteger(length);

        var strLength = length ? stringSize(string) : 0;
        return length && strLength < length ? createPadding(length - strLength, chars) + string : string;
    }

    module.exports = padStart;
});
//# sourceMappingURL=padStart.js.map