Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/overSome', ['module', 'exports', 'require', './_arraySome', './_createOver'], function (module, exports, require) {
  var define = undefined;
  var arraySome = require('./_arraySome'),
      createOver = require('./_createOver');

  /**
   * Creates a function that checks if **any** of the `predicates` return
   * truthy when invoked with the arguments it receives.
   *
   * Following shorthands are possible for providing predicates.
   * Pass an `Object` and it will be used as an parameter for `_.matches` to create the predicate.
   * Pass an `Array` of parameters for `_.matchesProperty` and the predicate will be created using them.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Util
   * @param {...(Function|Function[])} [predicates=[_.identity]]
   *  The predicates to check.
   * @returns {Function} Returns the new function.
   * @example
   *
   * var func = _.overSome([Boolean, isFinite]);
   *
   * func('1');
   * // => true
   *
   * func(null);
   * // => true
   *
   * func(NaN);
   * // => false
   *
   * var matchesFunc = _.overSome([{ 'a': 1 }, { 'a': 2 }])
   * var matchesPropertyFunc = _.overSome([['a', 1], ['a', 2]])
   */
  var overSome = createOver(arraySome);

  module.exports = overSome;
});
//# sourceMappingURL=overSome.js.map