Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/isWeakSet', ['module', 'exports', 'require', './_baseGetTag', './isObjectLike'], function (module, exports, require) {
  var define = undefined;
  var baseGetTag = require('./_baseGetTag'),
      isObjectLike = require('./isObjectLike');

  /** `Object#toString` result references. */
  var weakSetTag = '[object WeakSet]';

  /**
   * Checks if `value` is classified as a `WeakSet` object.
   *
   * @static
   * @memberOf _
   * @since 4.3.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a weak set, else `false`.
   * @example
   *
   * _.isWeakSet(new WeakSet);
   * // => true
   *
   * _.isWeakSet(new Set);
   * // => false
   */
  function isWeakSet(value) {
    return isObjectLike(value) && baseGetTag(value) == weakSetTag;
  }

  module.exports = isWeakSet;
});
//# sourceMappingURL=isWeakSet.js.map