Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/isError', ['module', 'exports', 'require', './_baseGetTag', './isObjectLike', './isPlainObject'], function (module, exports, require) {
    var define = undefined;
    var baseGetTag = require('./_baseGetTag'),
        isObjectLike = require('./isObjectLike'),
        isPlainObject = require('./isPlainObject');

    /** `Object#toString` result references. */
    var domExcTag = '[object DOMException]',
        errorTag = '[object Error]';

    /**
     * Checks if `value` is an `Error`, `EvalError`, `RangeError`, `ReferenceError`,
     * `SyntaxError`, `TypeError`, or `URIError` object.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an error object, else `false`.
     * @example
     *
     * _.isError(new Error);
     * // => true
     *
     * _.isError(Error);
     * // => false
     */
    function isError(value) {
        if (!isObjectLike(value)) {
            return false;
        }
        var tag = baseGetTag(value);
        return tag == errorTag || tag == domExcTag || typeof value.message == 'string' && typeof value.name == 'string' && !isPlainObject(value);
    }

    module.exports = isError;
});
//# sourceMappingURL=isError.js.map