Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/functions', ['module', 'exports', 'require', './_baseFunctions', './keys'], function (module, exports, require) {
  var define = undefined;
  var baseFunctions = require('./_baseFunctions'),
      keys = require('./keys');

  /**
   * Creates an array of function property names from own enumerable properties
   * of `object`.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Object
   * @param {Object} object The object to inspect.
   * @returns {Array} Returns the function names.
   * @see _.functionsIn
   * @example
   *
   * function Foo() {
   *   this.a = _.constant('a');
   *   this.b = _.constant('b');
   * }
   *
   * Foo.prototype.c = _.constant('c');
   *
   * _.functions(new Foo);
   * // => ['a', 'b']
   */
  function functions(object) {
    return object == null ? [] : baseFunctions(object, keys(object));
  }

  module.exports = functions;
});
//# sourceMappingURL=functions.js.map