Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/cond', ['module', 'exports', 'require', './_apply', './_arrayMap', './_baseIteratee', './_baseRest'], function (module, exports, require) {
  var define = undefined;
  var apply = require('./_apply'),
      arrayMap = require('./_arrayMap'),
      baseIteratee = require('./_baseIteratee'),
      baseRest = require('./_baseRest');

  /** Error message constants. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /**
   * Creates a function that iterates over `pairs` and invokes the corresponding
   * function of the first predicate to return truthy. The predicate-function
   * pairs are invoked with the `this` binding and arguments of the created
   * function.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Util
   * @param {Array} pairs The predicate-function pairs.
   * @returns {Function} Returns the new composite function.
   * @example
   *
   * var func = _.cond([
   *   [_.matches({ 'a': 1 }),           _.constant('matches A')],
   *   [_.conforms({ 'b': _.isNumber }), _.constant('matches B')],
   *   [_.stubTrue,                      _.constant('no match')]
   * ]);
   *
   * func({ 'a': 1, 'b': 2 });
   * // => 'matches A'
   *
   * func({ 'a': 0, 'b': 1 });
   * // => 'matches B'
   *
   * func({ 'a': '1', 'b': '2' });
   * // => 'no match'
   */
  function cond(pairs) {
    var length = pairs == null ? 0 : pairs.length;

    pairs = !length ? [] : arrayMap(pairs, function (pair) {
      if (typeof pair[1] != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return [baseIteratee(pair[0]), pair[1]];
    });

    return baseRest(function (args) {
      var index = -1;
      while (++index < length) {
        var pair = pairs[index];
        if (apply(pair[0], this, args)) {
          return apply(pair[1], this, args);
        }
      }
    });
  }

  module.exports = cond;
});
//# sourceMappingURL=cond.js.map