Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/camelCase', ['module', 'exports', 'require', './capitalize', './_createCompounder'], function (module, exports, require) {
  var define = undefined;
  var capitalize = require('./capitalize'),
      createCompounder = require('./_createCompounder');

  /**
   * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the camel cased string.
   * @example
   *
   * _.camelCase('Foo Bar');
   * // => 'fooBar'
   *
   * _.camelCase('--foo-bar--');
   * // => 'fooBar'
   *
   * _.camelCase('__FOO_BAR__');
   * // => 'fooBar'
   */
  var camelCase = createCompounder(function (result, word, index) {
    word = word.toLowerCase();
    return result + (index ? capitalize(word) : word);
  });

  module.exports = camelCase;
});
//# sourceMappingURL=camelCase.js.map