Liferay.Loader.define('frontend-js-react-web$lodash@4.17.21/_isKey', ['module', 'exports', 'require', './isArray', './isSymbol'], function (module, exports, require) {
  var define = undefined;
  var isArray = require('./isArray'),
      isSymbol = require('./isSymbol');

  /** Used to match property names within property paths. */
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
      reIsPlainProp = /^\w*$/;

  /**
   * Checks if `value` is a property name and not a property path.
   *
   * @private
   * @param {*} value The value to check.
   * @param {Object} [object] The object to query keys on.
   * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
   */
  function isKey(value, object) {
    if (isArray(value)) {
      return false;
    }
    var type = typeof value;
    if (type == 'number' || type == 'symbol' || type == 'boolean' || value == null || isSymbol(value)) {
      return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
  }

  module.exports = isKey;
});
//# sourceMappingURL=_isKey.js.map