Liferay.Loader.define("frontend-js-react-web@3.0.6/js/render.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = render;

  var _icon = require("@frontend-taglib-clay$clayui/icon");

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _reactDom = _interopRequireDefault(require("frontend-js-react-web$react-dom"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var counter = 0;
  /**
   * Wrapper for ReactDOM render that automatically:
   *
   * - Provides commonly-needed context (for example, the Clay spritemap).
   * - Unmounts when portlets are destroyed based on the received
   *   `portletId` value inside renderData. If none is passed, the
   *   component will be automatically unmounted before the next navigation.
   *
   * The React docs advise not to rely on the render return value, so we
   * don't propagate it.
   *
   * @see https://reactjs.org/docs/react-dom.html#render
   */

  function render(renderFunction, renderData, container) {
    var portletId = renderData.portletId;
    var spritemap = Liferay.ThemeDisplay.getPathThemeImages() + '/lexicon/icons.svg';
    var componentId = renderData.componentId;


    if (!componentId) {
      componentId = "__UNNAMED_COMPONENT__".concat(portletId, "__").concat(counter++);
    }

    Liferay.component(componentId, {
      destroy: function destroy() {
        _reactDom["default"].unmountComponentAtNode(container);
      }
    }, {
      destroyOnNavigate: !portletId,
      portletId: portletId
    }); // eslint-disable-next-line liferay-portal/no-react-dom-render

    _reactDom["default"].render(_react["default"].createElement(_icon.ClayIconSpriteContext.Provider, {
      value: spritemap
    }, renderFunction(renderData)), container);
  }
  //# sourceMappingURL=render.es.js.map
});
//# sourceMappingURL=render.es.js.map