Liferay.Loader.define("frontend-js-react-web@3.0.6/js/hooks/useInterval.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', './useIsMounted.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useInterval;

  var _react = require("frontend-js-react-web$react");

  var _useIsMounted = _interopRequireDefault(require("./useIsMounted.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Hook for scheduling a repeating function call with the specified
   * interval (in milliseconds).
   */
  function useInterval() {
    var isMounted = (0, _useIsMounted["default"])();
    return (0, _react.useCallback)(function schedule(fn, ms) {
      var handle = setInterval(function () {
        if (isMounted()) {
          fn();
        } else {
          clearInterval(handle);
        }
      }, ms);
      return function () {
        return clearInterval(handle);
      };
    }, [isMounted]);
  }
  //# sourceMappingURL=useInterval.es.js.map
});
//# sourceMappingURL=useInterval.es.js.map