Liferay.Loader.define("frontend-js-react-web@3.0.6/js/hooks/useEventListener.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useEventListener;

  var _react = require("frontend-js-react-web$react");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Hook for adding an event listener on mount and removing it on
   * unmount.
   *
   * Note that in general you should be using React's built-in delegated
   * event handling (ie. via `onclick`, `onfocus` etc attributes). This
   * hook is for those rarer cases where you need to attach a listener
   * outside of your component's DOM (eg. attaching a "scroll" or "resize"
   * listener to the `window`).
   */
  function useEventListener(eventName, handler, phase, target) {
    (0, _react.useEffect)(function () {
      target.addEventListener(eventName, handler, phase);
      return function () {
        target.removeEventListener(eventName, handler, phase);
      };
    }, [eventName, handler, phase, target]);
  }
  //# sourceMappingURL=useEventListener.es.js.map
});
//# sourceMappingURL=useEventListener.es.js.map