Liferay.Loader.define("frontend-js-node-shims$timers-browserify@2.0.4/main", ['module', 'exports', 'require', 'frontend-js-node-shims$setimmediate'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var apply = Function.prototype.apply;

    // DOM APIs, for completeness

    exports.setTimeout = function () {
      return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
    };
    exports.setInterval = function () {
      return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
    };
    exports.clearTimeout = exports.clearInterval = function (timeout) {
      if (timeout) {
        timeout.close();
      }
    };

    function Timeout(id, clearFn) {
      this._id = id;
      this._clearFn = clearFn;
    }
    Timeout.prototype.unref = Timeout.prototype.ref = function () {};
    Timeout.prototype.close = function () {
      this._clearFn.call(window, this._id);
    };

    // Does not start the time, just sets up the members needed.
    exports.enroll = function (item, msecs) {
      clearTimeout(item._idleTimeoutId);
      item._idleTimeout = msecs;
    };

    exports.unenroll = function (item) {
      clearTimeout(item._idleTimeoutId);
      item._idleTimeout = -1;
    };

    exports._unrefActive = exports.active = function (item) {
      clearTimeout(item._idleTimeoutId);

      var msecs = item._idleTimeout;
      if (msecs >= 0) {
        item._idleTimeoutId = setTimeout(function onTimeout() {
          if (item._onTimeout) item._onTimeout();
        }, msecs);
      }
    };

    // setimmediate attaches itself to the global object
    require("frontend-js-node-shims$setimmediate");
    exports.setImmediate = setImmediate;
    exports.clearImmediate = clearImmediate;
  }
});
//# sourceMappingURL=main.js.map