/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BaseBuiltInJSModule
implements JSModule {
    private final Collection<String> _dependencies;
    private final JSONObject _flagsJSONObject;
    private final String _id;
    private final JSPackage _jsPackage;
    private final String _name;
    private final String _resolvedId;

    public BaseBuiltInJSModule(JSPackage jsPackage, String name, Collection<String> dependencies, JSONObject flagsJSONObject) {
        this._jsPackage = jsPackage;
        this._name = name;
        this._dependencies = dependencies;
        this._flagsJSONObject = flagsJSONObject;
        this._id = ModuleNameUtil.getModuleId((JSPackage)this._jsPackage, (String)this._name);
        this._resolvedId = StringBundler.concat((String[])new String[]{this._jsPackage.getName(), "@", this._jsPackage.getVersion(), "/", this._name});
    }

    public Collection<String> getDependencies() {
        return this._dependencies;
    }

    public Collection<String> getDependencyPackageNames() {
        ArrayList<String> dependencyPackageNames = new ArrayList<String>();
        for (String dependency : this._dependencies) {
            String packageName = ModuleNameUtil.getPackageName((String)dependency);
            if (packageName == null) continue;
            dependencyPackageNames.add(packageName);
        }
        return dependencyPackageNames;
    }

    public JSONObject getFlagsJSONObject() {
        return this._flagsJSONObject;
    }

    public String getId() {
        return this._id;
    }

    public JSPackage getJSPackage() {
        return this._jsPackage;
    }

    public String getName() {
        return this._name;
    }

    public String getResolvedId() {
        return this._resolvedId;
    }

    public String getResolvedURL() {
        return "/o/js/resolved-module/" + this.getResolvedId();
    }

    public String getURL() {
        return "/o/js/module/" + ModuleNameUtil.getModuleId((JSPackage)this._jsPackage, (String)this._name);
    }

    public String toString() {
        return this.getId();
    }
}

