/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.InvalidNPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.UnsupportedNPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ServiceFactory.class})
public class NPMResolverServiceFactory
implements ServiceFactory<NPMResolver> {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile JSONFactory _jsonFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile NPMRegistry _npmRegistry;
    private ServiceRegistration<NPMResolver> _serviceRegistration;

    public NPMResolver getService(Bundle bundle, ServiceRegistration<NPMResolver> serviceRegistration) {
        URL packageURL = bundle.getEntry("META-INF/resources/package.json");
        if (packageURL == null) {
            return new InvalidNPMResolverImpl(bundle);
        }
        JSONObject packageJSONObject = this._createJSONObject(packageURL);
        URL manifestURL = bundle.getEntry("META-INF/resources/manifest.json");
        if (manifestURL == null) {
            return new UnsupportedNPMResolverImpl(bundle);
        }
        JSONObject manifestJSONObject = this._createJSONObject(manifestURL);
        JSONObject packagesJSONObject = manifestJSONObject.getJSONObject("packages");
        if (packagesJSONObject == null) {
            return new UnsupportedNPMResolverImpl(bundle);
        }
        return new NPMResolverImpl(bundle, this._npmRegistry, packageJSONObject, packagesJSONObject);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<NPMResolver> serviceRegistration, NPMResolver npmResolver) {
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(NPMResolver.class, (ServiceFactory)this, new Hashtable());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private JSONObject _createJSONObject(URL url) {
        try {
            return this._jsonFactory.createJSONObject(StringUtil.read((InputStream)url.openStream()));
        }
        catch (JSONException | IOException exception) {
            throw new RuntimeException("Unable to read " + url, exception);
        }
    }
}

