/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSBundle;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSModule;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.Manifest;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSBundleProcessor.class})
public class FlatNPMBundleProcessor
implements JSBundleProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FlatNPMBundleProcessor.class);
    private ExecutorService _executorService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public JSBundle process(Bundle bundle) {
        Enumeration enumeration;
        URL url = bundle.getEntry("META-INF/resources/package.json");
        if (url == null) {
            return null;
        }
        FlatJSBundle flatJSBundle = new FlatJSBundle(bundle);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Processing NPM bundle: " + flatJSBundle));
        }
        ArrayList<Future<Map.Entry>> futures = new ArrayList<Future<Map.Entry>>();
        URL manifestJSONURL = bundle.getEntry("META-INF/resources/manifest.json");
        if (manifestJSONURL != null) {
            futures.add(this._executorService.submit(() -> {
                String content = StringUtil.read((InputStream)manifestJSONURL.openStream());
                if (!content.contains("\"flags\"")) {
                    return new AbstractMap.SimpleImmutableEntry<URL, Object>(manifestJSONURL, null);
                }
                JSONObject jsonObject = this._jsonFactory.createJSONObject(content);
                return new AbstractMap.SimpleImmutableEntry<URL, JSONObject>(manifestJSONURL, jsonObject.getJSONObject("packages"));
            }));
        }
        if ((enumeration = bundle.findEntries("META-INF/resources", "package.json", true)) == null) {
            _log.error((Object)("No package.json files found in " + bundle));
            return null;
        }
        while (enumeration.hasMoreElements()) {
            URL packageJSONURL = (URL)enumeration.nextElement();
            futures.add(this._executorService.submit(() -> new AbstractMap.SimpleImmutableEntry<URL, JSONObject>(packageJSONURL, this._jsonFactory.createJSONObject(StringUtil.read((InputStream)packageJSONURL.openStream())))));
        }
        enumeration = bundle.findEntries("META-INF/resources", "*.js", true);
        if (enumeration == null) {
            _log.error((Object)("No *.js files found in " + bundle));
            return null;
        }
        ArrayList<Future<Map.Entry>> moduleDepedenciesFutures = new ArrayList<Future<Map.Entry>>();
        while (enumeration.hasMoreElements()) {
            URL jsURL = (URL)enumeration.nextElement();
            moduleDepedenciesFutures.add(this._executorService.submit(() -> new AbstractMap.SimpleImmutableEntry<URL, Collection<String>>(jsURL, this._parseModuleDependencies(this._getDefineArgs(jsURL)))));
        }
        HashMap<URL, Collection<String>> moduleDependenciesMap = new HashMap<URL, Collection<String>>();
        for (Future future : moduleDepedenciesFutures) {
            try {
                Map.Entry entry = (Map.Entry)future.get();
                moduleDependenciesMap.put((URL)entry.getKey(), (Collection<String>)entry.getValue());
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        HashMap<URL, JSONObject> jsonObjects = new HashMap<URL, JSONObject>();
        for (Future future : futures) {
            try {
                Map.Entry entry = (Map.Entry)future.get();
                jsonObjects.put((URL)entry.getKey(), (JSONObject)entry.getValue());
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        JSONObject jSONObject = (JSONObject)jsonObjects.remove(manifestJSONURL);
        Manifest manifest = new Manifest(jSONObject);
        JSONObject packageJSONObject = (JSONObject)jsonObjects.remove(url);
        this._processPackage(flatJSBundle, manifest, packageJSONObject, jsonObjects, moduleDependenciesMap, "/META-INF/resources", true);
        this._processNodePackages(flatJSBundle, manifest, jsonObjects, moduleDependenciesMap);
        return flatJSBundle;
    }

    @Activate
    protected void activate() {
        this._executorService = this._portalExecutorManager.getPortalExecutor(FlatNPMBundleProcessor.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._executorService.shutdownNow();
    }

    private String _canonicalizePath(String path) {
        int parents = 0;
        String[] parts = path.split("/");
        ArrayList<String> processedParts = new ArrayList<String>();
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                ++parents;
                continue;
            }
            if (parents > 0) {
                --parents;
                continue;
            }
            processedParts.add(part);
        }
        Collections.reverse(processedParts);
        StringBundler sb = new StringBundler(2 * processedParts.size() - 1);
        for (String processedPart : processedParts) {
            if (sb.length() != 0) {
                sb.append("/");
            }
            sb.append(processedPart);
        }
        return sb.toString();
    }

    private String _getDefineArgs(URL url) {
        try {
            String urlContent = this._normalizeModuleContent(StringUtil.read((InputStream)url.openStream()));
            int x = urlContent.indexOf("Liferay.Loader.define");
            if (x < 0) {
                return null;
            }
            if ((x = urlContent.indexOf(91, x + 21)) < 0) {
                return null;
            }
            int y = urlContent.indexOf(93, x + 1);
            if (y < 0) {
                return null;
            }
            return urlContent.substring(x + 1, y);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read URL: " + url), (Throwable)ioException);
            return null;
        }
    }

    private String _normalizeModuleContent(String moduleContent) {
        int index = (moduleContent = StringUtil.replace((String)moduleContent, (char)'\n', (char)' ')).indexOf("Liferay.Loader.define(");
        if (index == -1) {
            return "";
        }
        moduleContent = moduleContent.substring(index);
        index = 0;
        while (true) {
            if ((index = moduleContent.indexOf("function", index)) == -1 || index >= moduleContent.length()) {
                return "";
            }
            char nextChar = moduleContent.charAt(index + 8);
            if (Character.isWhitespace(nextChar) || nextChar == '(') break;
            index += 8;
        }
        moduleContent = moduleContent.substring(0, index);
        return moduleContent;
    }

    private Collection<String> _parseModuleDependencies(String defineArgs) {
        String[] dependencies = StringUtil.split((String)defineArgs);
        if (dependencies.length == 1 && dependencies[0].equals("")) {
            return Collections.emptyList();
        }
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = dependencies[i].trim();
            dependencies[i] = StringUtil.unquote((String)dependencies[i]);
        }
        return Arrays.asList(dependencies);
    }

    private void _processDependencies(FlatJSPackage flatJSPackage, JSONObject packageJSONObject, String key) {
        JSONObject dependenciesJSONObject = packageJSONObject.getJSONObject(key);
        if (dependenciesJSONObject != null) {
            Iterator dependencyNames = dependenciesJSONObject.keys();
            while (dependencyNames.hasNext()) {
                String dependencyName = (String)dependencyNames.next();
                String versionConstraints = dependenciesJSONObject.getString(dependencyName);
                flatJSPackage.addJSPackageDependency(new JSPackageDependency((JSPackage)flatJSPackage, dependencyName, versionConstraints));
            }
        }
    }

    private void _processModuleAliases(FlatJSPackage flatJSPackage, String location, Map<URL, JSONObject> jsonObjects, Map<URL, Collection<String>> moduleDependenciesMap) {
        HashSet<String> processedFolderPaths = new HashSet<String>();
        for (Map.Entry<URL, JSONObject> entry : jsonObjects.entrySet()) {
            JSONObject jsonObject;
            String main;
            URL url = entry.getKey();
            String filePath = url.getPath();
            if (!filePath.startsWith(location) || (filePath = filePath.substring(location.length())).equals("/package.json") || !Validator.isNotNull((String)(main = (jsonObject = entry.getValue()).getString("main", null)))) continue;
            String folderPath = filePath.substring(0, filePath.lastIndexOf("/"));
            String alias = folderPath.substring(1);
            if (!main.startsWith("/")) {
                main = this._canonicalizePath(alias + "/" + main);
            }
            main = ModuleNameUtil.toModuleName((String)main);
            JSModuleAlias jsModuleAlias = new JSModuleAlias((JSPackage)flatJSPackage, main, alias);
            flatJSPackage.addJSModuleAlias(jsModuleAlias);
            processedFolderPaths.add(folderPath);
        }
        for (URL url : moduleDependenciesMap.keySet()) {
            String folderPath = url.getPath();
            if (!folderPath.startsWith(location) || !folderPath.endsWith("/index.js")) continue;
            folderPath = folderPath.substring(location.length());
            if ((folderPath = folderPath.substring(0, folderPath.lastIndexOf("/"))).isEmpty()) continue;
            String alias = folderPath.substring(1);
            if (processedFolderPaths.contains(folderPath)) continue;
            flatJSPackage.addJSModuleAlias(new JSModuleAlias((JSPackage)flatJSPackage, alias + "/index", alias));
        }
    }

    private void _processModules(FlatJSPackage flatJSPackage, Manifest manifest, String location, Map<URL, Collection<String>> moduleDependenciesMap, boolean root) {
        String nodeModulesPath = location + "/node_modules/";
        for (Map.Entry<URL, Collection<String>> entry : moduleDependenciesMap.entrySet()) {
            Collection<String> dependencies;
            URL url = entry.getKey();
            String path = url.getPath();
            if (!path.startsWith(location) || path.startsWith(nodeModulesPath) || (dependencies = entry.getValue()) == null) continue;
            String fileName = path.substring(location.length() + 1);
            String name = ModuleNameUtil.toModuleName((String)fileName);
            String packageId = root ? "/" : flatJSPackage.getResolvedId();
            FlatJSModule flatJSModule = new FlatJSModule(flatJSPackage, name, dependencies, manifest.getFlagsJSONObject(packageId, fileName));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding NPM module: " + flatJSModule));
            }
            flatJSPackage.addJSModule(flatJSModule);
        }
    }

    private void _processNodePackages(FlatJSBundle flatJSBundle, Manifest manifest, Map<URL, JSONObject> jsonObjects, Map<URL, Collection<String>> moduleDependenciesMap) {
        for (Map.Entry<URL, JSONObject> entry : jsonObjects.entrySet()) {
            URL url = entry.getKey();
            String path = url.getPath();
            String location = path.substring(1, path.length() - 13);
            String[] parts = location.split("/");
            String lastFolderPath = parts[parts.length - 2];
            if (!lastFolderPath.equals("node_modules")) continue;
            this._processPackage(flatJSBundle, manifest, entry.getValue(), jsonObjects, moduleDependenciesMap, "/".concat(location), false);
        }
    }

    private void _processPackage(FlatJSBundle flatJSBundle, Manifest manifest, JSONObject packageJSONObject, Map<URL, JSONObject> jsonObjects, Map<URL, Collection<String>> moduleDependenciesMap, String location, boolean root) {
        String name = packageJSONObject.getString("name");
        if (Validator.isNull((String)name)) {
            return;
        }
        String version = packageJSONObject.getString("version");
        if (Validator.isNull((String)version)) {
            return;
        }
        String mainModuleName = null;
        String main = packageJSONObject.getString("main");
        if (Validator.isNull((String)main)) {
            mainModuleName = "index";
        } else {
            mainModuleName = ModuleNameUtil.toModuleName((String)main);
            if (mainModuleName.startsWith("./")) {
                mainModuleName = mainModuleName.substring(2);
            }
        }
        FlatJSPackage flatJSPackage = new FlatJSPackage(flatJSBundle, name, version, mainModuleName, root);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding NPM package: " + flatJSPackage));
        }
        this._processDependencies(flatJSPackage, packageJSONObject, "dependencies");
        this._processDependencies(flatJSPackage, packageJSONObject, "peerDependencies");
        this._processModules(flatJSPackage, manifest, location, moduleDependenciesMap, root);
        if (!root) {
            this._processModuleAliases(flatJSPackage, location, jsonObjects, moduleDependenciesMap);
        }
        flatJSBundle.addJSPackage(flatJSPackage);
    }
}

