/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class FlatJSModule
implements JSModule {
    private final Collection<String> _dependencies;
    private final JSONObject _flagsJSONObject;
    private final JSPackage _jsPackage;
    private final String _name;

    public FlatJSModule(JSPackage jsPackage, String name, Collection<String> dependencies, JSONObject flagsJSONObject) {
        this._jsPackage = jsPackage;
        this._name = name;
        this._dependencies = dependencies;
        this._flagsJSONObject = flagsJSONObject;
    }

    public Collection<String> getDependencies() {
        return this._dependencies;
    }

    public Collection<String> getDependencyPackageNames() {
        ArrayList<String> dependencyPackageNames = new ArrayList<String>();
        for (String dependency : this._dependencies) {
            String packageName = ModuleNameUtil.getPackageName((String)dependency);
            if (packageName == null) continue;
            dependencyPackageNames.add(packageName);
        }
        return dependencyPackageNames;
    }

    public JSONObject getFlagsJSONObject() {
        return this._flagsJSONObject;
    }

    public String getId() {
        return ModuleNameUtil.getModuleId((JSPackage)this._jsPackage, (String)this._name);
    }

    public InputStream getInputStream() throws IOException {
        String fileName = ModuleNameUtil.toFileName((String)this.getName());
        URL jsURL = this._jsPackage.getResourceURL(fileName);
        return jsURL.openStream();
    }

    public JSPackage getJSPackage() {
        return this._jsPackage;
    }

    public String getName() {
        return this._name;
    }

    public String getResolvedId() {
        StringBundler sb = new StringBundler(5);
        sb.append(this._jsPackage.getName());
        sb.append("@");
        sb.append(this._jsPackage.getVersion());
        sb.append("/");
        sb.append(this._name);
        return sb.toString();
    }

    public String getResolvedURL() {
        StringBundler sb = new StringBundler(2);
        sb.append("/o/js/resolved-module/");
        sb.append(this.getResolvedId());
        return sb.toString();
    }

    public InputStream getSourceMapInputStream() throws IOException {
        String fileName = ModuleNameUtil.toFileName((String)this.getName());
        URL sourceMapURL = this._jsPackage.getResourceURL(fileName + ".map");
        return sourceMapURL.openStream();
    }

    public String getURL() {
        StringBundler sb = new StringBundler(2);
        sb.append("/o/js/module/");
        sb.append(ModuleNameUtil.getModuleId((JSPackage)this._jsPackage, (String)this._name));
        return sb.toString();
    }

    public String toString() {
        return this.getId();
    }
}

