/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin.ResourceDescriptor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class BaseBuiltInJSModuleServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(BaseBuiltInJSModuleServlet.class);
    private ServiceTrackerMap<String, ResourceBundleLoader> _bundleSymbolicNameServiceTrackerMap;
    private final String _workDirName = StringBundler.concat((String[])new String[]{PropsValues.LIFERAY_HOME, File.separator, "work"});

    public void destroy() {
        this._bundleSymbolicNameServiceTrackerMap.close();
    }

    public void init() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        this._bundleSymbolicNameServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundle.getBundleContext(), ResourceBundleLoader.class, (String)"bundle.symbolic.name");
    }

    protected abstract MimeTypes getMimeTypes();

    protected abstract ResourceDescriptor getResourceDescriptor(String var1);

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String pathInfo = httpServletRequest.getPathInfo();
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor(pathInfo);
        if (resourceDescriptor == null) {
            httpServletResponse.sendError(404);
            return;
        }
        this._setContentType(httpServletResponse, pathInfo);
        String languageId = httpServletRequest.getParameter("languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        this._sendResource(httpServletResponse, resourceDescriptor, locale, pathInfo);
    }

    private void _sendResource(HttpServletResponse httpServletResponse, ResourceDescriptor resourceDescriptor, Locale locale, String pathInfo) throws IOException {
        URL url;
        JSPackage jsPackage;
        block20: {
            JSBundle jsBundle;
            File file;
            jsPackage = resourceDescriptor.getJsPackage();
            url = null;
            if (PropsValues.WORK_DIR_OVERRIDE_ENABLED && pathInfo.endsWith(".js") && (file = new File(this._workDirName, StringBundler.concat((String[])new String[]{(jsBundle = jsPackage.getJSBundle()).getName(), "-", jsBundle.getVersion(), File.separator, resourceDescriptor.getPackagePath()}))).exists()) {
                try {
                    URI uri = file.toURI();
                    url = uri.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!_log.isWarnEnabled()) break block20;
                    _log.warn((Object)("Invalid override URL " + file.toString()), (Throwable)malformedURLException);
                }
            }
        }
        if (url == null) {
            url = jsPackage.getResourceURL(resourceDescriptor.getPackagePath());
        }
        if (url == null) {
            httpServletResponse.sendError(404);
            return;
        }
        try (InputStream inputStream = url.openStream();){
            JSBundle jsBundle;
            ResourceBundleLoader resourceBundleLoader;
            String content = StringUtil.read((InputStream)inputStream);
            httpServletResponse.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            String extension = FileUtil.getExtension((String)pathInfo);
            if (extension.equals("js") && (resourceBundleLoader = (ResourceBundleLoader)this._bundleSymbolicNameServiceTrackerMap.getService((Object)(jsBundle = jsPackage.getJSBundle()).getName())) != null) {
                content = LanguageUtil.process(() -> resourceBundleLoader.loadResourceBundle(locale), (Locale)locale, (String)content);
            }
            printWriter.print(content);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read " + resourceDescriptor.toString()), (Throwable)ioException);
            httpServletResponse.sendError(500, "Unable to read file");
        }
    }

    private void _setContentType(HttpServletResponse httpServletResponse, String pathInfo) {
        String extension = FileUtil.getExtension((String)pathInfo);
        if (extension.equals("js")) {
            httpServletResponse.setContentType("text/javascript; charset=UTF-8");
        } else if (extension.equals("map")) {
            httpServletResponse.setContentType("application/json");
        } else {
            MimeTypes mimeTypes = this.getMimeTypes();
            httpServletResponse.setContentType(mimeTypes.getContentType(pathInfo));
        }
    }
}

