/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseBuiltInJSModuleServlet
extends HttpServlet {
    protected abstract JSModule getJSModule(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JSModule jsModule = this._resolveJSModule(request);
        if (jsModule == null) {
            response.sendError(404);
            return;
        }
        String contentType = null;
        InputStream inputStream = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(".map")) {
            contentType = "application/json";
            inputStream = jsModule.getSourceMapInputStream();
        } else {
            contentType = "text/javascript; charset=UTF-8";
            inputStream = jsModule.getInputStream();
        }
        response.setContentType(contentType);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        try {
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)servletOutputStream, (boolean)false);
        }
        catch (Exception e) {
            response.sendError(500, "Unable to read file");
        }
        finally {
            inputStream.close();
        }
    }

    private JSModule _resolveJSModule(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String identifier = pathInfo.substring(1);
        if (pathInfo.endsWith(".map")) {
            int index = identifier.lastIndexOf(".");
            identifier = identifier.substring(0, index);
        }
        String moduleName = ModuleNameUtil.toModuleName((String)identifier);
        return this.getJSModule(moduleName);
    }
}

