/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal;

import com.liferay.frontend.js.loader.modules.extender.internal.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModule;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesPortalWebResources;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.log.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesServlet", "osgi.http.whiteboard.servlet.pattern=/js_loader_modules", "service.ranking:Integer=2147482647"}, service={JSLoaderModulesServlet.class, Servlet.class})
public class JSLoaderModulesServlet
extends HttpServlet {
    private ComponentContext _componentContext;
    private volatile Details _details;
    private JSLoaderModulesTracker _jsLoaderModulesTracker;
    private Logger _logger;
    private NPMRegistry _npmRegistry;
    @Reference
    private Portal _portal;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._componentContext.enableComponent(JSLoaderModulesPortalWebResources.class.getName());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this._details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        this._logger = new Logger(componentContext.getBundleContext());
        this._componentContext = componentContext;
    }

    protected JSLoaderModulesTracker getJSLoaderModulesTracker() {
        return this._jsLoaderModulesTracker;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/javascript; charset=UTF-8");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream, true);
        printWriter.println("(function() {");
        printWriter.println("Liferay.PATHS = {");
        String delimiter = "";
        String delimiter2 = "";
        HashSet<String> processedNames = new HashSet<String>();
        Collection<JSLoaderModule> jsLoaderModules = this._jsLoaderModulesTracker.getJSLoaderModules();
        for (JSLoaderModule jSLoaderModule : jsLoaderModules) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jSLoaderModule.getName());
            printWriter.write("@");
            printWriter.write(jSLoaderModule.getVersion());
            printWriter.write("\": \"");
            printWriter.write(this._portal.getPathProxy());
            printWriter.write(jSLoaderModule.getContextPath());
            printWriter.write("\"");
            if (!processedNames.contains(jSLoaderModule.getName())) {
                processedNames.add(jSLoaderModule.getName());
                printWriter.println(",");
                printWriter.write("\"");
                printWriter.write(jSLoaderModule.getName());
                printWriter.write("\": \"");
                printWriter.write(this._portal.getPathProxy());
                printWriter.write(jSLoaderModule.getContextPath());
                printWriter.write("\"");
            }
            delimiter = ",\n";
        }
        Collection resolvedJSModules = this._npmRegistry.getResolvedJSModules();
        for (JSModule resolvedJSModule : resolvedJSModules) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(resolvedJSModule.getResolvedId());
            printWriter.write("\": \"");
            printWriter.write(this._portal.getPathProxy());
            printWriter.write(resolvedJSModule.getResolvedURL());
            printWriter.write("\"");
            delimiter = ",\n";
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.MODULES = {");
        delimiter = "";
        processedNames.clear();
        for (JSLoaderModule jsLoaderModule : jsLoaderModules) {
            String versionedConfiguration;
            String unversionedConfiguration = jsLoaderModule.getUnversionedConfiguration();
            if (unversionedConfiguration.length() == 0) continue;
            if (!processedNames.contains(jsLoaderModule.getName())) {
                processedNames.add(jsLoaderModule.getName());
                printWriter.write(delimiter);
                printWriter.write(unversionedConfiguration);
                delimiter = ",\n";
            }
            if ((versionedConfiguration = jsLoaderModule.getVersionedConfiguration()).length() <= 0) continue;
            printWriter.write(delimiter);
            printWriter.write(versionedConfiguration);
            delimiter = ",\n";
        }
        for (JSModule resolvedJSModule : resolvedJSModules) {
            Object dependency22;
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(resolvedJSModule.getResolvedId());
            printWriter.write("\": {\n");
            delimiter2 = "";
            printWriter.write("  \"dependencies\": [");
            for (Object dependency22 : resolvedJSModule.getDependencies()) {
                printWriter.write(delimiter2);
                printWriter.write("\"" + (String)dependency22 + "\"");
                delimiter2 = ", ";
            }
            printWriter.write("],\n");
            JSPackage jsPackage = resolvedJSModule.getJSPackage();
            delimiter2 = "";
            printWriter.write("  \"map\": {");
            dependency22 = resolvedJSModule.getDependencyPackageNames().iterator();
            while (dependency22.hasNext()) {
                String dependencyPackageName = (String)dependency22.next();
                if (dependencyPackageName == null) continue;
                printWriter.write(delimiter2);
                StringBundler aliasSB = new StringBundler(1);
                StringBundler aliasValueSB = new StringBundler();
                if (dependencyPackageName.equals(jsPackage.getName())) {
                    aliasSB.append(dependencyPackageName);
                    aliasValueSB.append(jsPackage.getResolvedId());
                } else {
                    JSPackageDependency jsPackageDependency = jsPackage.getJSPackageDependency(dependencyPackageName);
                    if (jsPackageDependency == null) {
                        aliasSB.append(dependencyPackageName);
                        aliasValueSB.append(":ERROR:Missing version constraints for ");
                        aliasValueSB.append(dependencyPackageName);
                        aliasValueSB.append(" in package.json of ");
                        aliasValueSB.append(jsPackage.getResolvedId());
                    } else {
                        JSPackage jsDependencyPackage = this._npmRegistry.resolveJSPackageDependency(jsPackageDependency);
                        if (jsDependencyPackage == null) {
                            aliasSB.append(dependencyPackageName);
                            aliasValueSB.append(":ERROR:Package ");
                            aliasValueSB.append(dependencyPackageName);
                            aliasValueSB.append(" which is a dependency of ");
                            aliasValueSB.append(jsPackage.getResolvedId());
                            aliasValueSB.append(" is not deployed in the server");
                        } else {
                            aliasSB.append(jsDependencyPackage.getName());
                            aliasValueSB.append(jsDependencyPackage.getResolvedId());
                        }
                    }
                }
                printWriter.write("\"");
                printWriter.write(aliasSB.toString());
                printWriter.write("\": \"");
                printWriter.write(aliasValueSB.toString());
                printWriter.write("\"");
                delimiter2 = ", ";
            }
            printWriter.write("}\n");
            printWriter.write("}");
            delimiter = ",\n";
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.MAPS = {");
        delimiter = "";
        processedNames.clear();
        for (JSLoaderModule jsLoaderModule : jsLoaderModules) {
            if (processedNames.contains(jsLoaderModule.getName())) continue;
            processedNames.add(jsLoaderModule.getName());
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("\": \"");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("@");
            printWriter.write(jsLoaderModule.getVersion());
            printWriter.write("\"");
            delimiter = ",\n";
            String unversionedMapsConfiguration = jsLoaderModule.getUnversionedMapsConfiguration();
            if (unversionedMapsConfiguration.equals("")) continue;
            printWriter.write(delimiter);
            printWriter.write(unversionedMapsConfiguration);
        }
        for (JSPackage jsPackage : this._npmRegistry.getResolvedJSPackages()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write(jsPackage.getResolvedId());
            printWriter.write("\": {exactMatch: true, value: \"");
            printWriter.write(jsPackage.getResolvedId());
            printWriter.write("/");
            printWriter.write(jsPackage.getMainModuleName());
            printWriter.write("\"}");
            delimiter = ",\n";
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                printWriter.write(delimiter);
                printWriter.write("\"");
                printWriter.write(jsPackage.getResolvedId());
                printWriter.write("/");
                printWriter.write(jsModuleAlias.getAlias());
                printWriter.write("\": {exactMatch: true, value: \"");
                printWriter.write(jsPackage.getResolvedId());
                printWriter.write("/");
                printWriter.write(jsModuleAlias.getModuleName());
                printWriter.write("\"}");
            }
        }
        Map map = this._npmRegistry.getGlobalAliases();
        for (Map.Entry alias : map.entrySet()) {
            printWriter.write(delimiter);
            printWriter.write("\"");
            printWriter.write((String)alias.getKey());
            printWriter.write("\"");
            printWriter.write(":");
            printWriter.write("\"");
            printWriter.write((String)alias.getValue());
            printWriter.write("\"");
            delimiter = ",\n";
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.EXPLAIN_RESOLUTIONS = " + this._details.explainResolutions() + ";\n");
        printWriter.println("Liferay.EXPOSE_GLOBAL = " + this._details.exposeGlobal() + ";\n");
        printWriter.println("}());");
        printWriter.close();
    }

    protected void setDetails(Details details) {
        this._details = details;
    }

    @Reference(unbind="-")
    protected void setJSLoaderModulesTracker(JSLoaderModulesTracker jsLoaderModulesTracker) {
        this._jsLoaderModulesTracker = jsLoaderModulesTracker;
    }

    @Reference(unbind="-")
    protected void setNPMRegistry(NPMRegistry npmRegistry) {
        this._npmRegistry = npmRegistry;
    }
}

