/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSBundle;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSModule;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSBundleProcessor.class})
public class FlatNPMBundleProcessor
implements JSBundleProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FlatNPMBundleProcessor.class);
    @Reference
    private JSONFactory _jsonFactory;

    public JSBundle process(Bundle bundle) {
        URL url = bundle.getResource("META-INF/resources/package.json");
        if (url == null) {
            return null;
        }
        FlatJSBundle flatJSBundle = new FlatJSBundle(bundle);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Processing NPM bundle: " + flatJSBundle));
        }
        this._processRootPackage(flatJSBundle);
        this._processNodePackages(flatJSBundle);
        return flatJSBundle;
    }

    private String _canonicalizePath(String path) {
        int parents = 0;
        String[] parts = path.split("/");
        ArrayList<String> processedParts = new ArrayList<String>();
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                ++parents;
                continue;
            }
            if (parents > 0) {
                --parents;
                continue;
            }
            processedParts.add(part);
        }
        Collections.reverse(processedParts);
        StringBundler sb = new StringBundler(2 * processedParts.size() - 1);
        for (String processedPart : processedParts) {
            if (sb.length() != 0) {
                sb.append("/");
            }
            sb.append(processedPart);
        }
        return sb.toString();
    }

    private String _getDefineArgs(URL url) {
        try {
            String urlContent = this._normalizeModuleContent(StringUtil.read((InputStream)url.openStream()));
            int x = urlContent.indexOf("Liferay.Loader.define");
            if (x < 0) {
                return null;
            }
            if ((x = urlContent.indexOf(91, x + 21)) < 0) {
                return null;
            }
            int y = urlContent.indexOf(93, x + 1);
            if (y < 0) {
                return null;
            }
            return urlContent.substring(x + 1, y);
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to read URL: " + url), (Throwable)ioe);
            return null;
        }
    }

    private JSONObject _getJSONObject(FlatJSBundle flatJSBundle, String location) {
        JSONObject jsonObject = null;
        try {
            String content = this._getResourceContent(flatJSBundle, location);
            if (content != null) {
                jsonObject = this._jsonFactory.createJSONObject(content);
            }
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse ", flatJSBundle, ": ", location}), (Throwable)e);
        }
        return jsonObject;
    }

    private String _getResourceContent(FlatJSBundle flatJSBundle, String location) {
        URL url = flatJSBundle.getResourceURL(location);
        if (url == null) {
            return null;
        }
        try {
            return StringUtil.read((InputStream)url.openStream());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private String _normalizeModuleContent(String moduleContent) {
        int index = (moduleContent = StringUtil.replace((String)moduleContent, (char)'\n', (char)' ')).indexOf("Liferay.Loader.define(");
        if (index == -1) {
            return "";
        }
        moduleContent = moduleContent.substring(index);
        index = 0;
        while (true) {
            if ((index = moduleContent.indexOf("function", index)) == -1 || index >= moduleContent.length()) {
                return "";
            }
            char nextChar = moduleContent.charAt(index + 8);
            if (Character.isWhitespace(nextChar) || nextChar == '(') break;
            index += 8;
        }
        moduleContent = moduleContent.substring(0, index);
        return moduleContent;
    }

    private Collection<String> _parseModuleDependencies(String defineArgs) {
        String[] dependencies = defineArgs.split(",");
        if (dependencies.length == 1 && dependencies[0].equals("")) {
            return Collections.emptyList();
        }
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = dependencies[i].trim();
            dependencies[i] = StringUtil.removeChars((String)dependencies[i], (char[])new char[]{'\'', '\"'});
        }
        return Arrays.asList(dependencies);
    }

    private void _processDependencies(FlatJSPackage flatJSPackage, JSONObject jsonObject, String key) {
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject(key);
        if (dependenciesJSONObject != null) {
            Iterator dependencyNames = dependenciesJSONObject.keys();
            while (dependencyNames.hasNext()) {
                String dependencyName = (String)dependencyNames.next();
                String versionConstraints = dependenciesJSONObject.getString(dependencyName);
                flatJSPackage.addJSPackageDependency(new JSPackageDependency((JSPackage)flatJSPackage, dependencyName, versionConstraints));
            }
        }
    }

    private void _processModuleAliases(FlatJSPackage flatJSPackage, String location) {
        URL url;
        HashSet<String> processedFolderPaths = new HashSet<String>();
        FlatJSBundle flatJSBundle = flatJSPackage.getJSBundle();
        Enumeration<URL> urls = flatJSBundle.findEntries(location, "package.json", true);
        while (urls.hasMoreElements()) {
            String main;
            JSONObject jsonObject;
            url = urls.nextElement();
            String filePath = url.getPath();
            if ((filePath = filePath.substring(location.length() + 1)).equals("/package.json") || (jsonObject = this._getJSONObject(flatJSBundle, url.getPath())) == null || !Validator.isNotNull((String)(main = jsonObject.getString("main", null)))) continue;
            String folderPath = filePath.substring(0, filePath.lastIndexOf("/"));
            String alias = folderPath.substring(1);
            if (main.startsWith(".")) {
                main = this._canonicalizePath(alias + "/" + main);
            }
            main = ModuleNameUtil.toModuleName((String)main);
            JSModuleAlias jsModuleAlias = new JSModuleAlias((JSPackage)flatJSPackage, main, alias);
            flatJSPackage.addJSModuleAlias(jsModuleAlias);
            processedFolderPaths.add(folderPath);
        }
        urls = flatJSBundle.findEntries(location, "index.js", true);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                String folderPath = url.getPath();
                folderPath = folderPath.substring(location.length() + 1);
                if ((folderPath = folderPath.substring(0, folderPath.lastIndexOf("/"))).isEmpty()) continue;
                String alias = folderPath.substring(1);
                if (processedFolderPaths.contains(folderPath)) continue;
                flatJSPackage.addJSModuleAlias(new JSModuleAlias((JSPackage)flatJSPackage, alias + "/index", alias));
            }
        }
    }

    private void _processModules(FlatJSPackage flatJSPackage, String location) {
        String nodeModulesPath = "/" + location + "/node_modules/";
        FlatJSBundle flatJSBundle = flatJSPackage.getJSBundle();
        Enumeration<URL> urls = flatJSBundle.findEntries(location, "*.js", true);
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            String defineArgs;
            URL url = urls.nextElement();
            String path = url.getPath();
            if (path.startsWith(nodeModulesPath) || (defineArgs = this._getDefineArgs(url)) == null) continue;
            String name = ModuleNameUtil.toModuleName((String)path.substring(location.length() + 2));
            Collection<String> dependencies = this._parseModuleDependencies(defineArgs);
            FlatJSModule flatJSModule = new FlatJSModule(flatJSPackage, name, dependencies);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding NPM module: " + flatJSModule));
            }
            flatJSPackage.addJSModule(flatJSModule);
        }
    }

    private void _processNodePackages(FlatJSBundle flatJSBundle) {
        Enumeration<URL> urls = flatJSBundle.findEntries("META-INF/resources", "package.json", true);
        while (urls.hasMoreElements()) {
            String location;
            String[] parts;
            String lastFolderPath;
            URL url = urls.nextElement();
            String path = url.getPath();
            if (path.equals("/META-INF/resources/package.json") || !(lastFolderPath = (parts = (location = path.substring(1, path.length() - 13)).split("/"))[parts.length - 2]).equals("node_modules")) continue;
            this._processPackage(flatJSBundle, location, false);
        }
    }

    private void _processPackage(FlatJSBundle flatJSBundle, String location, boolean root) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(this._getResourceContent(flatJSBundle, location + "/package.json"));
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse package of ", flatJSBundle, ": ", location, "/package.json"}), (Throwable)e);
            return;
        }
        String mainModuleName = null;
        String main = jsonObject.getString("main");
        if (Validator.isNull((String)main)) {
            mainModuleName = "index";
        } else {
            mainModuleName = ModuleNameUtil.toModuleName((String)main);
            if (mainModuleName.startsWith("./")) {
                mainModuleName = mainModuleName.substring(2);
            }
        }
        FlatJSPackage flatJSPackage = new FlatJSPackage(flatJSBundle, jsonObject.getString("name"), jsonObject.getString("version"), mainModuleName, root);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding NPM package: " + flatJSPackage));
        }
        this._processDependencies(flatJSPackage, jsonObject, "dependencies");
        this._processDependencies(flatJSPackage, jsonObject, "peerDependencies");
        this._processModules(flatJSPackage, location);
        if (!root) {
            this._processModuleAliases(flatJSPackage, location);
        }
        flatJSBundle.addJSPackage(flatJSPackage);
    }

    private void _processRootPackage(FlatJSBundle flatJSBundle) {
        String location = "META-INF/resources";
        this._processPackage(flatJSBundle, location, true);
    }
}

