/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin.ResourceDescriptor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class BaseBuiltInJSModuleServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(BaseBuiltInJSModuleServlet.class);
    private ServiceTrackerMap<String, ResourceBundleLoader> _bundleSymbolicNameServiceTrackerMap;

    public void destroy() {
        this._bundleSymbolicNameServiceTrackerMap.close();
    }

    public void init() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        this._bundleSymbolicNameServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundle.getBundleContext(), ResourceBundleLoader.class, (String)"bundle.symbolic.name");
    }

    protected abstract MimeTypes getMimeTypes();

    protected abstract ResourceDescriptor getResourceDescriptor(String var1);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor(pathInfo);
        if (resourceDescriptor == null) {
            response.sendError(404);
            return;
        }
        this._setContentType(response, pathInfo);
        String languageId = request.getParameter("languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        this._sendResource(response, resourceDescriptor, locale);
    }

    private void _sendResource(HttpServletResponse response, ResourceDescriptor resourceDescriptor, Locale locale) throws IOException {
        JSPackage jsPackage = resourceDescriptor.getJsPackage();
        URL url = jsPackage.getResourceURL(resourceDescriptor.getPackagePath());
        if (url == null) {
            response.sendError(404);
            return;
        }
        try (InputStream inputStream = url.openStream();){
            String content = StringUtil.read((InputStream)inputStream);
            response.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = response.getWriter();
            JSBundle jsBundle = jsPackage.getJSBundle();
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this._bundleSymbolicNameServiceTrackerMap.getService((Object)jsBundle.getName());
            if (resourceBundleLoader != null) {
                content = LanguageUtil.process(() -> resourceBundleLoader.loadResourceBundle(locale), (Locale)locale, (String)content);
            }
            printWriter.print(content);
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to read " + resourceDescriptor.toString()), (Throwable)ioe);
            response.sendError(500, "Unable to read file");
        }
    }

    private void _setContentType(HttpServletResponse response, String pathInfo) {
        String extension = FileUtil.getExtension((String)pathInfo);
        if (extension.equals(".js")) {
            response.setContentType("text/javascript; charset=UTF-8");
        } else if (extension.equals(".map")) {
            response.setContentType("application/json");
        } else {
            MimeTypes mimeTypes = this.getMimeTypes();
            response.setContentType(mimeTypes.getContentType(pathInfo));
        }
    }
}

