/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class JSLoaderModule {
    private static final Log _log = LogFactoryUtil.getLog(JSLoaderModule.class);
    private final boolean _applyVersioning;
    private final Bundle _bundle;
    private final String _contextPath;
    private final String _name;
    private String _unversionedConfiguration = "";
    private String _unversionedMapsConfiguration = "";
    private final String _version;
    private String _versionedConfiguration = "";

    public JSLoaderModule(boolean applyVersioning, Bundle bundle, String contextPath) {
        this._applyVersioning = applyVersioning;
        this._bundle = bundle;
        this._contextPath = contextPath;
        Version version = this._bundle.getVersion();
        this._version = version.toString();
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        List bundleCapabilities = bundleWiring.getCapabilities("osgi.webresource");
        if (bundleCapabilities.isEmpty()) {
            this._name = this._bundle.getSymbolicName();
            return;
        }
        BundleCapability bundleCapability = (BundleCapability)bundleCapabilities.get(0);
        Map attributes = bundleCapability.getAttributes();
        this._name = (String)attributes.get("osgi.webresource");
        URL url = this._bundle.getEntry("META-INF/config.json");
        this.urlToConfiguration(url, bundleWiring);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getName() {
        return this._name;
    }

    public String getUnversionedConfiguration() {
        return this._unversionedConfiguration;
    }

    public String getUnversionedMapsConfiguration() {
        return this._unversionedMapsConfiguration;
    }

    public String getVersion() {
        return this._version;
    }

    public String getVersionedConfiguration() {
        return this._versionedConfiguration;
    }

    protected String generateConfiguration(JSONObject jsonObject, BundleWiring bundleWiring, boolean versionedModuleName) {
        if (!this._applyVersioning) {
            if (versionedModuleName) {
                return "";
            }
            return jsonObject.toString();
        }
        JSONArray namesJSONArray = jsonObject.names();
        if (namesJSONArray == null) {
            return jsonObject.toString();
        }
        List bundleWires = bundleWiring.getRequiredWires("osgi.webresource");
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            String moduleName;
            String name = (String)namesJSONArray.get(i);
            int x = name.indexOf(47);
            if (x == -1 || !(moduleName = name.substring(0, x)).equals(this.getName())) continue;
            String modulePath = name.substring(x);
            moduleName = StringBundler.concat((String[])new String[]{this.getName(), "@", this.getVersion(), modulePath});
            JSONObject nameJSONObject = jsonObject.getJSONObject(name);
            JSONArray dependenciesJSONArray = nameJSONObject.getJSONArray("dependencies");
            for (int j = 0; j < dependenciesJSONArray.length(); ++j) {
                String dependency = dependenciesJSONArray.getString(j);
                int y = dependency.indexOf(47);
                if (y == -1) continue;
                String dependencyName = dependency.substring(0, y);
                String dependencyPath = dependency.substring(y);
                if (dependencyName.equals(this.getName())) {
                    dependencyName = StringBundler.concat((String[])new String[]{this.getName(), "@", this.getVersion(), dependencyPath});
                    dependenciesJSONArray.put(j, (Object)dependencyName);
                    continue;
                }
                this.normalizeDependencies(dependencyName, dependencyPath, dependenciesJSONArray, j, bundleWires);
            }
            if (versionedModuleName) {
                jsonObject.remove(name);
                jsonObject.put(moduleName, (Object)nameJSONObject);
                continue;
            }
            jsonObject.put(name, (Object)nameJSONObject);
        }
        return jsonObject.toString();
    }

    protected String generateMapsConfiguration(String configuration, String[] jsSubmodulesExport) {
        boolean exportAll = ArrayUtil.contains((Object[])jsSubmodulesExport, (Object)"*");
        JSONObject mapsConfigurationJSONObject = new JSONObject();
        JSONObject configurationJSONObject = new JSONObject("{" + configuration + "}");
        JSONArray namesJSONArray = configurationJSONObject.names();
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            String name = (String)namesJSONArray.get(i);
            int x = name.indexOf(47);
            String moduleRootPath = name.substring(0, x + 1);
            String submodulePath = name.substring(x + 1);
            int y = submodulePath.indexOf(47);
            if (y == -1) continue;
            final String submoduleName = submodulePath.substring(0, y);
            PredicateFilter<String> wildcardPredicateFilter = new PredicateFilter<String>(){

                public boolean filter(String item) {
                    return JSLoaderModule.this._matchesWildcard(submoduleName, item);
                }
            };
            if (!exportAll && !ArrayUtil.exists((Object[])jsSubmodulesExport, (PredicateFilter)wildcardPredicateFilter)) continue;
            mapsConfigurationJSONObject.put(submoduleName, (Object)moduleRootPath.concat(submoduleName));
        }
        return mapsConfigurationJSONObject.toString();
    }

    protected String normalize(String jsonString) {
        if (jsonString.startsWith("{") && jsonString.endsWith("}")) {
            jsonString = jsonString.substring(1, jsonString.length() - 1);
        }
        return jsonString;
    }

    protected void normalizeDependencies(String dependencyName, String dependencyPath, JSONArray jsonArray, int index, List<BundleWire> bundleWires) {
        for (BundleWire bundleWire : bundleWires) {
            BundleCapability bundleCapability = bundleWire.getCapability();
            Map attributes = bundleCapability.getAttributes();
            String attributesDependencyName = (String)attributes.get("osgi.webresource");
            if (!attributesDependencyName.equals(dependencyName)) continue;
            Version version = (Version)attributes.get("version");
            dependencyName = StringBundler.concat((String[])new String[]{dependencyName, "@", version.toString(), dependencyPath});
            jsonArray.put(index, (Object)dependencyName);
            return;
        }
    }

    protected void urlToConfiguration(URL url, BundleWiring bundleWiring) {
        if (url == null) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            JSONTokener jsonTokener = new JSONTokener((Reader)reader);
            JSONObject jsonObject = new JSONObject(jsonTokener);
            this._unversionedConfiguration = this.normalize(this.generateConfiguration(jsonObject, bundleWiring, false));
            this._versionedConfiguration = this.normalize(this.generateConfiguration(jsonObject, bundleWiring, true));
            Dictionary headers = this._bundle.getHeaders("");
            String jsSubmodulesExport = GetterUtil.getString((String)((String)headers.get("Liferay-JS-Submodules-Export")));
            if (Validator.isNotNull((String)jsSubmodulesExport)) {
                this._unversionedMapsConfiguration = this.normalize(this.generateMapsConfiguration(this._unversionedConfiguration, StringUtil.split((String)jsSubmodulesExport)));
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Liferay-JS-Submodules-Export is deprecated and replaced with Liferay-JS-Submodules-Bridge");
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean _matchesWildcard(String text, String pattern) {
        pattern = StringUtil.replace((String)pattern, (String[])new String[]{"?", "*"}, (String[])new String[]{".?", ".*"});
        return text.matches(pattern);
    }
}

