/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModuleNameUtil {
    private static final Set<String> _reservedModuleNames = new HashSet<String>(Arrays.asList("exports", "module", "require"));

    public static String getDependencyPath(String moduleName, String dependency) {
        if (!ModuleNameUtil.isLocalModuleName(dependency)) {
            return dependency;
        }
        List<String> moduleDirNameParts = ModuleNameUtil._getDirNameParts(moduleName);
        if (dependency.equals(".")) {
            return StringUtil.merge(moduleDirNameParts, (String)"/");
        }
        if (dependency.equals("..")) {
            return StringUtil.merge(moduleDirNameParts.subList(0, moduleDirNameParts.size() - 1), (String)"/");
        }
        List<String> dependencyDirNameParts = ModuleNameUtil._getDirNameParts(dependency);
        for (String dependencyDirNamePart : dependencyDirNameParts) {
            if (dependencyDirNamePart.equals(".")) continue;
            if (dependencyDirNamePart.equals("..")) {
                if (moduleDirNameParts.isEmpty()) {
                    throw new IllegalArgumentException("Invalid dependency " + dependency);
                }
                moduleDirNameParts.remove(moduleDirNameParts.size() - 1);
                continue;
            }
            moduleDirNameParts.add(dependencyDirNamePart);
        }
        moduleDirNameParts.add(ModuleNameUtil._getFileName(dependency));
        return StringUtil.merge(moduleDirNameParts, (String)"/");
    }

    public static String getModuleId(JSPackage jsPackage, String moduleName) {
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getId());
        sb.append("/");
        sb.append(moduleName);
        return sb.toString();
    }

    public static String getModuleResolvedId(JSPackage jsPackage, String moduleName) {
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getResolvedId());
        sb.append("/");
        sb.append(moduleName);
        return sb.toString();
    }

    public static String getPackageName(String moduleName) {
        if (ModuleNameUtil.isLocalModuleName(moduleName)) {
            return null;
        }
        if (ModuleNameUtil.isReservedModuleName(moduleName)) {
            return null;
        }
        int i = moduleName.indexOf("/");
        if (moduleName.charAt(0) == '@' && i != -1) {
            i = moduleName.indexOf("/", i + 1);
        }
        if (i == -1) {
            return moduleName;
        }
        return moduleName.substring(0, i);
    }

    public static String getPackagePath(String moduleName) {
        if (ModuleNameUtil.isLocalModuleName(moduleName)) {
            return null;
        }
        int i = moduleName.indexOf("/");
        if (moduleName.charAt(0) == '@' && i != -1) {
            i = moduleName.indexOf("/", i + 1);
        }
        if (i == -1) {
            return null;
        }
        return moduleName.substring(i + 1);
    }

    public static boolean isLocalModuleName(String moduleName) {
        return moduleName.equals(".") || moduleName.equals("..") || moduleName.startsWith("./") || moduleName.startsWith("../");
    }

    public static boolean isReservedModuleName(String moduleName) {
        return _reservedModuleNames.contains(moduleName);
    }

    public static String toFileName(String moduleName) {
        return moduleName + ".js";
    }

    public static String toModuleName(String fileName) {
        String extension = FileUtil.getExtension((String)fileName);
        if (!extension.equals("js")) {
            return fileName;
        }
        return FileUtil.stripExtension((String)fileName);
    }

    private static List<String> _getDirNameParts(String modulePath) {
        ArrayList<String> modulePathParts = new ArrayList<String>(Arrays.asList(modulePath.split("/")));
        modulePathParts.remove(modulePathParts.size() - 1);
        return modulePathParts;
    }

    private static String _getFileName(String dependency) {
        int pos = dependency.lastIndexOf("/");
        return dependency.substring(pos + 1);
    }
}

