/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ModuleNameUtil {
    private static final Set<String> _reservedModuleNames = new HashSet<String>(Arrays.asList("exports", "module", "require"));

    public static String getModuleId(JSPackage jsPackage, String moduleName) {
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getId());
        sb.append("/");
        sb.append(moduleName);
        return sb.toString();
    }

    public static String getPackageName(String moduleName) {
        if (ModuleNameUtil.isLocalModuleName(moduleName)) {
            return null;
        }
        if (ModuleNameUtil.isReservedModuleName(moduleName)) {
            return null;
        }
        int i = moduleName.indexOf("/");
        if (moduleName.charAt(0) == '@' && i != -1) {
            i = moduleName.indexOf("/", i + 1);
        }
        if (i == -1) {
            return moduleName;
        }
        return moduleName.substring(0, i);
    }

    public static String getPackagePath(String moduleName) {
        if (ModuleNameUtil.isLocalModuleName(moduleName)) {
            return null;
        }
        int i = moduleName.indexOf("/");
        if (moduleName.charAt(0) == '@' && i != -1) {
            i = moduleName.indexOf("/", i + 1);
        }
        if (i == -1) {
            return null;
        }
        return moduleName.substring(i + 1);
    }

    public static boolean isLocalModuleName(String moduleName) {
        return moduleName.startsWith("./") || moduleName.startsWith("../");
    }

    public static boolean isReservedModuleName(String moduleName) {
        return _reservedModuleNames.contains(moduleName);
    }

    public static String toFileName(String moduleName) {
        return moduleName + ".js";
    }

    public static String toModuleName(String fileName) {
        String extension = FileUtil.getExtension((String)fileName);
        if (!extension.equals("js")) {
            return fileName;
        }
        return FileUtil.stripExtension((String)fileName);
    }
}

