Liferay.Loader.define("frontend-js-jquery-web$jquery@3.5.1/src/css/adjustCSS", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	define(["../core", "../var/rcssNum"], function (jQuery, rcssNum) {

		"use strict";

		return function adjustCSS(elem, prop, valueParts, tween) {
			var adjusted,
			    scale,
			    maxIterations = 20,
			    currentValue = tween ? function () {
				return tween.cur();
			} : function () {
				return jQuery.css(elem, prop, "");
			},
			    initial = currentValue(),
			    unit = valueParts && valueParts[3] || (jQuery.cssNumber[prop] ? "" : "px"),


			// Starting value computation is required for potential unit mismatches
			initialInUnit = elem.nodeType && (jQuery.cssNumber[prop] || unit !== "px" && +initial) && rcssNum.exec(jQuery.css(elem, prop));

			if (initialInUnit && initialInUnit[3] !== unit) {

				// Support: Firefox <=54
				// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
				initial = initial / 2;

				// Trust units reported by jQuery.css
				unit = unit || initialInUnit[3];

				// Iteratively approximate from a nonzero starting point
				initialInUnit = +initial || 1;

				while (maxIterations--) {

					// Evaluate and update our best guess (doubling guesses that zero out).
					// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
					jQuery.style(elem, prop, initialInUnit + unit);
					if ((1 - scale) * (1 - (scale = currentValue() / initial || 0.5)) <= 0) {
						maxIterations = 0;
					}
					initialInUnit = initialInUnit / scale;
				}

				initialInUnit = initialInUnit * 2;
				jQuery.style(elem, prop, initialInUnit + unit);

				// Make sure we update the tween properties later on
				valueParts = valueParts || [];
			}

			if (valueParts) {
				initialInUnit = +initialInUnit || +initial || 0;

				// Apply relative offset (+=/-=) if specified
				adjusted = valueParts[1] ? initialInUnit + (valueParts[1] + 1) * valueParts[2] : +valueParts[2];
				if (tween) {
					tween.unit = unit;
					tween.start = initialInUnit;
					tween.end = adjusted;
				}
			}
			return adjusted;
		};
	});
});
//# sourceMappingURL=adjustCSS.js.map