/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

import Container from './Container';
import Item from './Item';
import ItemList from './ItemList';
import ResultsBar from './ResultsBar';
import ResultsBarItem from './ResultsBarItem';
import Search from './Search';

import './ManagementToolbar.scss';

const ManagementToolbar: Partial<IProps> = {};

ManagementToolbar.Container = Container;
ManagementToolbar.Item = Item;
ManagementToolbar.ItemList = ItemList;
ManagementToolbar.ResultsBar = ResultsBar;
ManagementToolbar.ResultsBarItem = ResultsBarItem;
ManagementToolbar.Search = Search;

export default ManagementToolbar as IProps;

interface IProps {
	Container: typeof Container;
	Item: typeof Item;
	ItemList: typeof ItemList;
	ResultsBar: typeof ResultsBar;
	ResultsBarItem: typeof ResultsBarItem;
	Search: typeof Search;
}
