Liferay.Loader.define("frontend-js-components-web@1.0.17/treeview/useKeyboardNavigation", ['module', 'exports', 'require', 'frontend-js-react-web$react', './TreeviewContext'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useKeyboardNavigation;

  var _react = require("frontend-js-react-web$react");

  var _TreeviewContext = _interopRequireDefault(require("./TreeviewContext"));

  var _KEY_CODES_TO_ACTIONS;

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode
   */
  var KEYS = {
    DOWN: 40,
    END: 35,
    ENTER: 13,
    HOME: 36,
    LEFT: 37,
    NUMPAD_STAR: 106,
    RIGHT: 39,
    SPACE: 32,
    TAB: 9,
    UP: 38
  };
  var HANDLED_KEY_CODES = new Set(Object.values(KEYS));
  /**
   * Manage transitions according to accessibility recommendations here:
   *
   * http://oaa-accessibility.org/examplep/treeview1/
   *
   * Plus "SPACE", which is the default key for toggling checkboxes.
   */

  var KEY_CODES_TO_ACTIONS = (_KEY_CODES_TO_ACTIONS = {}, _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.DOWN, 'SELECT_NEXT_VISIBLE'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.END, 'SELECT_LAST_VISIBLE'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.ENTER, 'TOGGLE_EXPANDED'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.HOME, 'SELECT_ROOT'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.LEFT, 'COLLAPSE_PARENT'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.NUMPAD_STAR, 'EXPAND_ALL'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.RIGHT, 'EXPAND_AND_ENTER'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.SPACE, 'TOGGLE_SELECT'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.TAB, 'EXIT'), _defineProperty(_KEY_CODES_TO_ACTIONS, KEYS.UP, 'SELECT_PREVIOUS_VISIBLE'), _KEY_CODES_TO_ACTIONS);

  function useKeyboardNavigation(nodeId) {
    var _useContext = (0, _react.useContext)(_TreeviewContext["default"]),
        dispatch = _useContext.dispatch,
        state = _useContext.state;

    var focusedNodeId = state.focusedNodeId;
    var handleKeyDown = (0, _react.useCallback)(function (event) {
      var keyCode = event.keyCode;

      if (focusedNodeId === nodeId && HANDLED_KEY_CODES.has(keyCode)) {
        if (keyCode !== KEYS.TAB) {
          // We intercept and manage all key presses internally,
          // except for TAB, which is used to navigate away from the
          // component (requires a `tabindex` of -1 on all internal
          // components).
          event.preventDefault();
        }

        dispatch({
          nodeId: nodeId,
          type: KEY_CODES_TO_ACTIONS[keyCode]
        });
      }
    }, [dispatch, focusedNodeId, nodeId]);
    return handleKeyDown;
  }
  //# sourceMappingURL=useKeyboardNavigation.js.map
});
//# sourceMappingURL=useKeyboardNavigation.js.map