Liferay.Loader.define("frontend-js-components-web@1.0.17/treeview/useFocus", ['module', 'exports', 'require', 'frontend-js-react-web$react', './TreeviewContext'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useFocus;

  var _react = require("frontend-js-react-web$react");

  var _TreeviewContext = _interopRequireDefault(require("./TreeviewContext"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function useFocus(nodeId) {
    var _useContext = (0, _react.useContext)(_TreeviewContext["default"]),
        state = _useContext.state;

    var active = state.active,
        focusedNodeId = state.focusedNodeId;
    var focusable = (0, _react.useRef)();
    (0, _react.useEffect)(function () {
      if (active && nodeId === focusedNodeId && focusable.current) {
        focusable.current.focus();
      }
    }, [active, focusedNodeId, nodeId]);
    return focusable;
  }
  //# sourceMappingURL=useFocus.js.map
});
//# sourceMappingURL=useFocus.js.map